/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.coreplusminecraft.rule;

import agency.highlysuspect.apathy.core.rule.CoolGsonHelper;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Partial;
import agency.highlysuspect.apathy.core.rule.PartialSpecAlways;
import agency.highlysuspect.apathy.core.rule.Spec;
import agency.highlysuspect.apathy.coreplusminecraft.ApathyPlusMinecraft;
import agency.highlysuspect.apathy.coreplusminecraft.MinecraftConv;
import agency.highlysuspect.apathy.coreplusminecraft.PlayerSetManagerGuts;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class PartialSpecDefenderInPlayerSet
implements Spec<Partial, PartialSpecDefenderInPlayerSet> {
    private final Set<String> playerSetNames;

    public PartialSpecDefenderInPlayerSet(Set<String> playerSetNames) {
        this.playerSetNames = playerSetNames;
    }

    @Override
    public Spec<Partial, ?> optimize() {
        if (this.playerSetNames.isEmpty()) {
            return PartialSpecAlways.FALSE;
        }
        return this;
    }

    @Override
    public Partial build() {
        return (attacker, defender) -> {
            ServerPlayer defenderSp = MinecraftConv.player(defender);
            MinecraftServer server = defenderSp.m_20194_();
            assert (server != null);
            PlayerSetManagerGuts setManager = ApathyPlusMinecraft.instanceMinecraft.getFor(server);
            for (String playerSetName : this.playerSetNames) {
                if (!setManager.playerInSet(defenderSp, playerSetName)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public JsonSerializer<PartialSpecDefenderInPlayerSet> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<PartialSpecDefenderInPlayerSet> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void write(PartialSpecDefenderInPlayerSet thing, JsonObject json) {
            json.add("player_sets", (JsonElement)thing.playerSetNames.stream().map(JsonPrimitive::new).collect(CoolGsonHelper.toJsonArray()));
        }

        @Override
        public PartialSpecDefenderInPlayerSet read(JsonObject json) {
            return new PartialSpecDefenderInPlayerSet(StreamSupport.stream(json.getAsJsonArray("player_sets").spliterator(), false).map(JsonElement::getAsString).collect(Collectors.toSet()));
        }
    }
}

