/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.coreplusminecraft.rule;

import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Partial;
import agency.highlysuspect.apathy.core.rule.Spec;
import agency.highlysuspect.apathy.core.rule.ThresholdMode;
import agency.highlysuspect.apathy.core.rule.Who;
import agency.highlysuspect.apathy.coreplusminecraft.MinecraftConv;
import com.google.gson.JsonObject;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.Objective;

public class PartialSpecScore
implements Spec<Partial, PartialSpecScore> {
    private final String scoreboardObjective;
    private final Who who;
    private final ThresholdMode thresholdMode;
    private final int threshold;

    public PartialSpecScore(String scoreboardObjective, Who who, ThresholdMode thresholdMode, int threshold) {
        this.scoreboardObjective = scoreboardObjective;
        this.who = who;
        this.thresholdMode = thresholdMode;
        this.threshold = threshold;
    }

    @Override
    public Partial build() {
        return (attacker, defender) -> {
            ServerScoreboard scoreboard = MinecraftConv.level(defender).m_6188_();
            Objective objective = scoreboard.m_83477_(this.scoreboardObjective);
            if (objective == null) {
                return false;
            }
            Entity which = (Entity)this.who.choose(MinecraftConv.mob(attacker), MinecraftConv.player(defender));
            String scoreboardName = which.m_6302_();
            int score = scoreboard.m_83461_(scoreboardName, objective) ? scoreboard.m_83471_(scoreboardName, objective).m_83400_() : 0;
            return this.thresholdMode.test(score, this.threshold);
        };
    }

    @Override
    public JsonSerializer<PartialSpecScore> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<PartialSpecScore> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void write(PartialSpecScore thing, JsonObject json) {
            json.addProperty("objective", thing.scoreboardObjective);
            json.addProperty("who", thing.who.toString());
            json.addProperty("thresholdMode", thing.thresholdMode.toString());
            json.addProperty("threshold", (Number)thing.threshold);
        }

        @Override
        public PartialSpecScore read(JsonObject json) {
            String scoreboardObjective = json.get("objective").getAsString();
            Who who = json.has("who") ? Who.fromString(json.get("who").getAsString()) : Who.DEFENDER;
            ThresholdMode thresholdMode = ThresholdMode.fromString(json.get("thresholdMode").getAsString());
            int threshold = json.get("threshold").getAsInt();
            return new PartialSpecScore(scoreboardObjective, who, thresholdMode, threshold);
        }
    }
}

