/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.mixin;

import agency.highlysuspect.apathy.Apathy120;
import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.CoreGenOptions;
import agency.highlysuspect.apathy.core.TriState;
import agency.highlysuspect.apathy.core.wrapper.ApathyDifficulty;
import agency.highlysuspect.apathy.core.wrapper.Attacker;
import agency.highlysuspect.apathy.core.wrapper.AttackerType;
import agency.highlysuspect.apathy.core.wrapper.VecThree;
import agency.highlysuspect.apathy.coreplusminecraft.MinecraftConv;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public class MobMixin
implements Attacker {
    @Shadow
    private LivingEntity f_21362_;
    @Unique
    private int recheckIntervalCache = Integer.MIN_VALUE;
    @Unique
    long provocationTime = Long.MIN_VALUE;
    @Unique
    @Nullable
    Vec3 spawnPosition;
    @Unique
    @Nullable
    Map<String, TriState> locationPredicateCache;
    @Unique
    @Nullable
    String spawnType;
    @Unique
    private static final String PROVOCATION_KEY = "apathy-provocationTime";
    @Unique
    private static final String SPAWN_POSITION_KEY = "apathy-spawnPosition";
    @Unique
    private static final String LOCATION_PREDICATE_CACHE_KEY = "apathy-locationPredicateCache";
    @Unique
    private static final String SPAWN_TYPE_KEY = "apathy-spawnType";

    @Override
    public Object apathy$underlyingObject() {
        return this;
    }

    @Override
    public ApathyDifficulty apathy$getDifficulty() {
        return MinecraftConv.toApathyDifficulty(((Mob)this).m_9236_().m_46791_());
    }

    @Override
    public AttackerType apathy$getType() {
        return (AttackerType)((Mob)this).m_6095_();
    }

    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true)
    public void apathy$whenSettingTarget(@Nullable LivingEntity newTarget, CallbackInfo ci) {
        Mob thi$ = (Mob)this;
        if (thi$.m_9236_().f_46443_) {
            return;
        }
        if (newTarget instanceof ServerPlayer && !Apathy120.instance120.allowedToTargetPlayer(thi$, (ServerPlayer)newTarget)) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void apathy$whenTicking(CallbackInfo ci) {
        Mob thi$ = (Mob)this;
        if (thi$.m_9236_().f_46443_) {
            return;
        }
        if (this.spawnPosition == null) {
            this.spawnPosition = thi$.m_20182_();
        }
        long gametime = thi$.m_9236_().m_46467_();
        if (this.recheckIntervalCache == Integer.MIN_VALUE || gametime % 400L == 0L) {
            this.recheckIntervalCache = Apathy.instance.generalCfg.get(CoreGenOptions.recheckInterval);
        }
        if ((gametime + (long)thi$.m_19879_()) % (long)this.recheckIntervalCache == 0L && this.f_21362_ instanceof ServerPlayer && !Apathy120.instance120.allowedToTargetPlayer(thi$, (ServerPlayer)this.f_21362_)) {
            this.f_21362_ = null;
        }
    }

    @Override
    public void apathy$setProvocationTime(long time) {
        this.provocationTime = time;
    }

    @Override
    public long apathy$getProvocationTime() {
        return this.provocationTime;
    }

    @Override
    public long apathy$now() {
        return ((Mob)this).m_9236_().m_46467_();
    }

    @Override
    @Nullable
    public VecThree apathy$getSpawnPosition() {
        return MinecraftConv.toVecThree(this.spawnPosition);
    }

    @Override
    @Nullable
    public Map<String, TriState> apathy$getOrCreateLocationPredicateCache() {
        if (this.locationPredicateCache == null) {
            this.locationPredicateCache = new HashMap<String, TriState>();
        }
        return this.locationPredicateCache;
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")})
    public void apathy$finalizeSpawn(ServerLevelAccessor blah, DifficultyInstance blahblah, MobSpawnType mobSpawnType, SpawnGroupData blahblahblah, CompoundTag blahblahblahblah, CallbackInfoReturnable<SpawnGroupData> cir) {
        this.spawnType = mobSpawnType.name().toLowerCase(Locale.ROOT);
    }

    @Override
    @Nullable
    public String apathy$getSpawnType() {
        return this.spawnType;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    public void apathy$whenSaving(CompoundTag tag, CallbackInfo ci) {
        if (this.apathy$getProvocationTime() != Long.MIN_VALUE) {
            tag.m_128356_(PROVOCATION_KEY, this.provocationTime);
        }
        if (this.spawnPosition != null) {
            ListTag asdf = new ListTag();
            asdf.add((Object)DoubleTag.m_128500_((double)this.spawnPosition.f_82479_));
            asdf.add((Object)DoubleTag.m_128500_((double)this.spawnPosition.f_82480_));
            asdf.add((Object)DoubleTag.m_128500_((double)this.spawnPosition.f_82481_));
            tag.m_128365_(SPAWN_POSITION_KEY, (Tag)asdf);
        }
        if (this.locationPredicateCache != null) {
            CompoundTag real = new CompoundTag();
            this.locationPredicateCache.forEach((k, v) -> real.m_128359_(k, v.toString()));
            tag.m_128365_(LOCATION_PREDICATE_CACHE_KEY, (Tag)real);
        }
        if (this.spawnType != null) {
            tag.m_128359_(SPAWN_TYPE_KEY, this.spawnType);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    public void apathy$whenLoading(CompoundTag tag, CallbackInfo ci) {
        this.provocationTime = tag.m_128441_(PROVOCATION_KEY) ? tag.m_128454_(PROVOCATION_KEY) : Long.MIN_VALUE;
        if (tag.m_128441_(SPAWN_POSITION_KEY)) {
            ListTag asdf = tag.m_128437_(SPAWN_POSITION_KEY, (int)DoubleTag.m_128500_((double)69420.0).m_7060_());
            this.spawnPosition = new Vec3(asdf.m_128772_(0), asdf.m_128772_(1), asdf.m_128772_(2));
        } else {
            this.spawnPosition = null;
        }
        if (tag.m_128441_(LOCATION_PREDICATE_CACHE_KEY)) {
            this.locationPredicateCache = new HashMap<String, TriState>();
            CompoundTag real = tag.m_128469_(LOCATION_PREDICATE_CACHE_KEY);
            for (String k : real.m_128431_()) {
                this.locationPredicateCache.put(k, TriState.fromString(real.m_128461_(k)));
            }
        } else {
            this.locationPredicateCache = null;
        }
        this.spawnType = tag.m_128441_(SPAWN_TYPE_KEY) ? tag.m_128461_(SPAWN_TYPE_KEY) : null;
    }

    @Override
    public int apathy$uuidBits() {
        return ((Mob)this).m_20148_().hashCode();
    }
}

