/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.mixin.dragon;

import agency.highlysuspect.apathy.Apathy120;
import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.CoreBossOptions;
import agency.highlysuspect.apathy.core.wrapper.DragonDuck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnderDragon.class})
public class EnderDragonMixin
implements DragonDuck {
    @Unique
    private boolean allowedToTargetPlayers = true;
    @Unique
    private static final String KEY = "apathy-allowed-to-target-players";

    @ModifyVariable(method={"knockBack"}, at=@At(value="HEAD"), argsOnly=true)
    private List<Entity> apathy$filterKnockBack(List<Entity> entities) {
        if (!Apathy.instance.bossCfg.get(CoreBossOptions.dragonKnockback).booleanValue()) {
            return Collections.emptyList();
        }
        EnderDragon dergon = (EnderDragon)this;
        ArrayList<Entity> copy = new ArrayList<Entity>(entities);
        copy.removeIf(e -> {
            ServerPlayer player;
            return e instanceof ServerPlayer && !Apathy120.instance120.allowedToTargetPlayer((Mob)dergon, player = (ServerPlayer)e);
        });
        return copy;
    }

    @ModifyVariable(method={"hurt(Ljava/util/List;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private List<Entity> apathy$filterHurt(List<Entity> entities) {
        if (!Apathy.instance.bossCfg.get(CoreBossOptions.dragonDamage).booleanValue()) {
            return Collections.emptyList();
        }
        EnderDragon dergon = (EnderDragon)this;
        ArrayList<Entity> copy = new ArrayList<Entity>(entities);
        copy.removeIf(e -> {
            if (!(e instanceof ServerPlayer)) return false;
            ServerPlayer player = (ServerPlayer)e;
            if (!this.allowedToTargetPlayers) return true;
            if (Apathy120.instance120.allowedToTargetPlayer((Mob)dergon, player)) return false;
            return true;
        });
        return copy;
    }

    @Inject(method={"canAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void apathy$copypasteFromLivingEntityMixin(LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            if (target instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)target;
                if (!this.allowedToTargetPlayers || !Apathy120.instance120.allowedToTargetPlayer(mob, player)) {
                    cir.setReturnValue((Object)false);
                }
            }
        }
    }

    @Override
    public void apathy$allowAttackingPlayers() {
        this.allowedToTargetPlayers = true;
    }

    @Override
    public void apathy$disallowAttackingPlayers() {
        this.allowedToTargetPlayers = false;
    }

    @Override
    public boolean apathy$canTargetPlayers() {
        return this.allowedToTargetPlayers;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void apathy$saveMoreData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_(KEY, this.allowedToTargetPlayers);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void apathy$loadMoreData(CompoundTag tag, CallbackInfo ci) {
        this.allowedToTargetPlayers = tag.m_128441_(KEY) ? tag.m_128471_(KEY) : true;
    }
}

