/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.platform.forge;

import agency.highlysuspect.apathy.core.Apathy;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.fml.loading.FMLPaths;

public class LegacyToTomlUpgrader {
    private static final Pattern headerPattern = Pattern.compile("^## (.*) ##$");
    private static final Pattern entryPattern = Pattern.compile("^([^#:]*):\\s*(.*)$");

    public static void doIt() {
        Path dir = FMLPaths.CONFIGDIR.get();
        if (Files.exists(dir.resolve("apathy-boss.toml"), new LinkOption[0])) {
            return;
        }
        try {
            LegacyToTomlUpgrader.reallyDoIt(dir.resolve("apathy").resolve("general.cfg"), dir.resolve("apathy-general.toml"));
            LegacyToTomlUpgrader.reallyDoIt(dir.resolve("apathy").resolve("mobs.cfg"), dir.resolve("apathy-mobs.toml"));
            LegacyToTomlUpgrader.reallyDoIt(dir.resolve("apathy").resolve("boss.cfg"), dir.resolve("apathy-boss.toml"));
            Path oldMobsJson = dir.resolve("apathy").resolve("mobs.json");
            if (Files.exists(oldMobsJson, new LinkOption[0])) {
                Apathy.instance.log.warn("MOVING MOBS.JSON FROM {} TO {}", oldMobsJson, Apathy.instance.mobsJsonPath());
                Files.copy(oldMobsJson, Apathy.instance.mobsJsonPath(), new CopyOption[0]);
                Files.delete(oldMobsJson);
            }
        }
        catch (Exception e) {
            Apathy.instance.log.error("Problem upgrading old config: " + e.getMessage(), e);
        }
    }

    private static void reallyDoIt(Path oldPath, Path newPath) throws IOException {
        if (Files.notExists(oldPath, new LinkOption[0])) {
            return;
        }
        if (Files.exists(newPath, new LinkOption[0])) {
            return;
        }
        Apathy.instance.log.warn("UPGRADING OLD-FORMAT CONFIG AT {} TO TOML-FORMAT CONFIG AT {}", oldPath, newPath);
        ArrayList<Object> newFile = new ArrayList<Object>();
        newFile.add("[Uncategorized]");
        for (String oldLine : Files.readAllLines(oldPath, StandardCharsets.UTF_8)) {
            Matcher m = headerPattern.matcher(oldLine);
            if (m.matches()) {
                newFile.add("[\"" + m.group(1) + "\"]");
                continue;
            }
            m = entryPattern.matcher(oldLine);
            if (!m.matches()) continue;
            String value = m.group(2).trim();
            boolean unquotedInToml = "true".equals(value) || "false".equals(value);
            try {
                Long.parseLong(value);
                unquotedInToml = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            newFile.add(m.group(1).trim() + "=" + (String)(unquotedInToml ? value : "\"" + value + "\""));
        }
        if (newPath.getParent() != null) {
            Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
        }
        Files.write(newPath, newFile, StandardCharsets.UTF_8, new OpenOption[0]);
        Files.delete(oldPath);
    }
}

