/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class NotRegistry<T> {
    protected final Map<String, T> byName = new HashMap<String, T>();
    protected final Map<T, String> byThing = new IdentityHashMap<T, String>();
    private static final String OPTIONAL_PREFIX = "apathy:";
    private static final int OPTIONAL_PREFIX_LENGTH = "apathy:".length();

    public T register(String name, T thing) {
        if (name.startsWith(OPTIONAL_PREFIX)) {
            name = name.substring(OPTIONAL_PREFIX_LENGTH);
        }
        this.byName.put(name, thing);
        this.byThing.put(thing, name);
        return thing;
    }

    public T get(String name) {
        if (name.startsWith(OPTIONAL_PREFIX)) {
            name = name.substring(OPTIONAL_PREFIX_LENGTH);
        }
        return this.byName.get(name);
    }

    public String getName(T thing) {
        return this.byThing.get(thing);
    }

    public Set<String> names() {
        return this.byName.keySet();
    }

    public void unregister(String name) {
        T thing;
        if (name.startsWith(OPTIONAL_PREFIX)) {
            name = name.substring(OPTIONAL_PREFIX_LENGTH);
        }
        if ((thing = this.get(name)) == null) {
            return;
        }
        this.byThing.remove(thing);
        this.byName.remove(name);
    }
}

