/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core;

import java.util.Locale;

public enum TriState {
    FALSE,
    DEFAULT,
    TRUE;


    public boolean get() {
        return this == TRUE;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toAllowDenyPassString() {
        switch (this) {
            case FALSE: {
                return "deny";
            }
            case DEFAULT: {
                return "pass";
            }
            case TRUE: {
                return "allow";
            }
        }
        throw new IllegalArgumentException("Someone's been tampering with the universe!");
    }

    public static TriState fromString(String ya) {
        switch (ya.toLowerCase(Locale.ROOT)) {
            case "false": {
                return FALSE;
            }
            case "true": {
                return TRUE;
            }
        }
        return DEFAULT;
    }

    public static TriState fromAllowDenyPassString(String ya) {
        switch (ya.toLowerCase(Locale.ROOT)) {
            case "deny": {
                return FALSE;
            }
            case "pass": {
                return DEFAULT;
            }
            case "allow": {
                return TRUE;
            }
        }
        throw new IllegalArgumentException("expected 'allow', 'deny', or 'pass'");
    }

    public static TriState fromBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }
}

