/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.coreplusminecraft;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.TriState;
import agency.highlysuspect.apathy.core.config.ConfigProperty;
import agency.highlysuspect.apathy.core.config.ConfigSchema;
import agency.highlysuspect.apathy.core.rule.Who;
import agency.highlysuspect.apathy.coreplusminecraft.ApathyPlusMinecraft;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;

public class MinecraftMobOptions {
    public static final ConfigProperty<Set<MobEffect>> mobEffectSet = ((ConfigProperty.Builder)MinecraftMobOptions.mobEffectSetOpt("potionEffectSet", Collections.singleton(MobEffects.f_19609_), "A set of potion effects.", "Example: minecraft:invisibility, minecraft:jump_boost")).build();
    public static final ConfigProperty<Who> mobEffectWho = ((ConfigProperty.Builder)ConfigProperty.whoOpt("potionEffectWho", Who.DEFENDER, "Whose potion effects will be checked?", "May be one of:", "attacker - The attacking mob's potion effects will be checked.", "defender - The player's potion effects will be checked.")).build();
    public static final ConfigProperty<TriState> mobEffectSetIncluded = ((ConfigProperty.Builder)ConfigProperty.allowDenyPassOpt("potionEffectSetIncluded", TriState.DEFAULT, "What happens when the entity has a potion effect included in potionEffectSet?", "May be one of:", "allow - The mob will be allowed to attack the player.", "deny  - The mob will not be allowed to attack the player.", "pass  - Defer to the next rule.")).build();
    public static final ConfigProperty<TriState> mobEffectSetExcluded = ((ConfigProperty.Builder)ConfigProperty.allowDenyPassOpt("potionEffectSetExcluded", TriState.DEFAULT, "What happens when the entity does not have any potion effects included in potionEffectSet?", "May be one of:", "allow - The mob will be allowed to attack the player.", "deny  - The mob will not be allowed to attack the player.", "pass  - Defer to the next rule.")).build();

    public static void visit(ConfigSchema schema) {
        schema.afterSection("Tag Set Rule", "Potion Effect Set Rule", mobEffectSet, mobEffectWho, mobEffectSetIncluded, mobEffectSetExcluded);
    }

    private static <B extends ConfigProperty.Builder<Set<MobEffect>, B>> B mobEffectSetOpt(String name, Set<MobEffect> defaultValue, String ... comment) {
        return (B)((ConfigProperty.Builder)((ConfigProperty.Builder)new ConfigProperty.Builder(name, defaultValue).comment(comment)).writer(set -> set.stream().map(arg_0 -> ApathyPlusMinecraft.instanceMinecraft.mobEffectRegistry().m_7981_(arg_0)).filter(Objects::nonNull).map(ResourceLocation::toString).sorted().collect(Collectors.joining(", ")))).parser(s -> Arrays.stream(s.trim().split(",")).map(String::trim).flatMap(st -> {
            ResourceLocation rl = ResourceLocation.m_135820_((String)st);
            if (rl == null) {
                Apathy.instance.log.warn("invalid resource location: " + st, new Object[0]);
                return Stream.of(new ResourceLocation[0]);
            }
            return Stream.of(rl);
        }).flatMap(rl -> {
            MobEffect effect = (MobEffect)ApathyPlusMinecraft.instanceMinecraft.mobEffectRegistry().m_7745_(rl);
            if (effect == null) {
                Apathy.instance.log.warn("invalid mob effect: " + rl, new Object[0]);
                return Stream.of(new MobEffect[0]);
            }
            return Stream.of(effect);
        }).collect(Collectors.toSet()));
    }
}

