/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.coreplusminecraft.rule;

import agency.highlysuspect.apathy.core.rule.CoolGsonHelper;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Partial;
import agency.highlysuspect.apathy.core.rule.Spec;
import agency.highlysuspect.apathy.coreplusminecraft.MinecraftConv;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;

public class PartialSpecDefenderHasAdvancement
implements Spec<Partial, PartialSpecDefenderHasAdvancement> {
    private final Set<ResourceLocation> advancementIds;

    public PartialSpecDefenderHasAdvancement(Set<ResourceLocation> advancementIds) {
        this.advancementIds = advancementIds;
    }

    @Override
    public Partial build() {
        return (attacker, defender) -> {
            ServerPlayer defenderSp = MinecraftConv.player(defender);
            MinecraftServer server = defenderSp.f_8924_;
            ServerAdvancementManager serverAdvancementManager = server.m_129889_();
            PlayerAdvancements playerAdvancements = defenderSp.m_8960_();
            for (ResourceLocation advancementId : this.advancementIds) {
                Advancement adv = serverAdvancementManager.m_136041_(advancementId);
                if (adv == null || !playerAdvancements.m_135996_(adv).m_8193_()) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public JsonSerializer<PartialSpecDefenderHasAdvancement> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<PartialSpecDefenderHasAdvancement> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void write(PartialSpecDefenderHasAdvancement thing, JsonObject json) {
            json.add("advancements", (JsonElement)thing.advancementIds.stream().map(rl -> new JsonPrimitive(rl.toString())).collect(CoolGsonHelper.toJsonArray()));
        }

        @Override
        public PartialSpecDefenderHasAdvancement read(JsonObject json) {
            return new PartialSpecDefenderHasAdvancement(CoolGsonHelper.streamArray(json.getAsJsonArray("advancements")).map(JsonElement::getAsString).map(ResourceLocation::new).collect(Collectors.toSet()));
        }
    }
}

