/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.platform.forge;

import agency.highlysuspect.apathy.Apathy119;
import agency.highlysuspect.apathy.core.config.ConfigSchema;
import agency.highlysuspect.apathy.coreplusminecraft.ApathyCommands;
import agency.highlysuspect.apathy.coreplusminecraft.ApathyPlusMinecraft;
import agency.highlysuspect.apathy.platform.forge.ForgeBackedConfig;
import agency.highlysuspect.apathy.platform.forge.LegacyToTomlUpgrader;
import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod(value="apathy")
public class ForgeInit
extends Apathy119 {
    private final ForgeConfigSpec.Builder generalForgeSpec;
    private final ForgeConfigSpec.Builder mobsForgeSpec;
    private final ForgeConfigSpec.Builder bossForgeSpec;
    private final ForgeConfigSpec generalForge;
    private final ForgeConfigSpec mobsForge;
    private final ForgeConfigSpec bossForge;

    public ForgeInit() {
        LegacyToTomlUpgrader.doIt();
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (remoteVersion, isFromServer) -> true));
        this.generalForgeSpec = new ForgeConfigSpec.Builder();
        this.mobsForgeSpec = new ForgeConfigSpec.Builder();
        this.bossForgeSpec = new ForgeConfigSpec.Builder();
        this.init();
        this.generalForge = this.generalForgeSpec.build();
        this.mobsForge = this.mobsForgeSpec.build();
        this.bossForge = this.bossForgeSpec.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.generalForge, "apathy-general.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.mobsForge, "apathy-mobs.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.bossForge, "apathy-boss.toml");
    }

    @Override
    public void installConfigFileReloader() {
        MinecraftForge.EVENT_BUS.addListener(event -> event.addListener(new PreparableReloadListener(){

            public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return ((CompletableFuture)CompletableFuture.runAsync(() -> {}, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenRunAsync(ForgeInit.this::refreshConfig, gameExecutor);
            }
        }));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> {
            if (e.getConfig().getSpec() == this.generalForge) {
                this.refreshGeneralConfig();
            } else if (e.getConfig().getSpec() == this.mobsForge) {
                this.refreshMobConfig();
            } else if (e.getConfig().getSpec() == this.bossForge) {
                this.refreshBossConfig();
            }
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> {
            if (e.getConfig().getSpec() == this.generalForge) {
                this.refreshGeneralConfig();
            } else if (e.getConfig().getSpec() == this.mobsForge) {
                this.refreshMobConfig();
            } else if (e.getConfig().getSpec() == this.bossForge) {
                this.refreshBossConfig();
            }
        });
    }

    @Override
    public void installCommandRegistrationCallback() {
        MinecraftForge.EVENT_BUS.addListener(e -> ApathyCommands.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
    }

    @Override
    public void installPlayerSetManagerTicker() {
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.START) {
                ApathyPlusMinecraft.instanceMinecraft.getFor(ServerLifecycleHooks.getCurrentServer()).syncWithConfig();
            }
        });
    }

    @Override
    public ConfigSchema.Bakery generalConfigBakery() {
        return new ForgeBackedConfig.Bakery(this.generalForgeSpec);
    }

    @Override
    public ConfigSchema.Bakery mobsConfigBakery() {
        return new ForgeBackedConfig.Bakery(this.mobsForgeSpec);
    }

    @Override
    public ConfigSchema.Bakery bossConfigBakery() {
        return new ForgeBackedConfig.Bakery(this.bossForgeSpec);
    }

    @Override
    public Path mobsJsonPath() {
        return FMLPaths.CONFIGDIR.get().resolve("apathy-mobs.json");
    }

    @Override
    public Path dumpsDirPath() {
        return FMLPaths.GAMEDIR.get().resolve("apathy-dumps");
    }
}

