/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core;

import agency.highlysuspect.apathy.core.CoreBossOptions;
import agency.highlysuspect.apathy.core.CoreGenOptions;
import agency.highlysuspect.apathy.core.CoreMobOptions;
import agency.highlysuspect.apathy.core.JsonRule;
import agency.highlysuspect.apathy.core.NotRegistry;
import agency.highlysuspect.apathy.core.TriState;
import agency.highlysuspect.apathy.core.config.ConfigSchema;
import agency.highlysuspect.apathy.core.config.CookedConfig;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Partial;
import agency.highlysuspect.apathy.core.rule.PartialSpecAll;
import agency.highlysuspect.apathy.core.rule.PartialSpecAlways;
import agency.highlysuspect.apathy.core.rule.PartialSpecAny;
import agency.highlysuspect.apathy.core.rule.PartialSpecAttackerIs;
import agency.highlysuspect.apathy.core.rule.PartialSpecAttackerIsBoss;
import agency.highlysuspect.apathy.core.rule.PartialSpecAttackerTaggedWith;
import agency.highlysuspect.apathy.core.rule.PartialSpecDifficultyIs;
import agency.highlysuspect.apathy.core.rule.PartialSpecNot;
import agency.highlysuspect.apathy.core.rule.PartialSpecRandom;
import agency.highlysuspect.apathy.core.rule.PartialSpecRevengeTimer;
import agency.highlysuspect.apathy.core.rule.PartialSpecSpawnType;
import agency.highlysuspect.apathy.core.rule.Rule;
import agency.highlysuspect.apathy.core.rule.RuleSpecAlways;
import agency.highlysuspect.apathy.core.rule.RuleSpecChain;
import agency.highlysuspect.apathy.core.rule.RuleSpecDebug;
import agency.highlysuspect.apathy.core.rule.RuleSpecDifficultyCase;
import agency.highlysuspect.apathy.core.rule.RuleSpecIf;
import agency.highlysuspect.apathy.core.rule.RuleSpecJson;
import agency.highlysuspect.apathy.core.rule.RuleSpecPredicated;
import agency.highlysuspect.apathy.core.rule.Spec;
import agency.highlysuspect.apathy.core.wrapper.Attacker;
import agency.highlysuspect.apathy.core.wrapper.AttackerTag;
import agency.highlysuspect.apathy.core.wrapper.AttackerType;
import agency.highlysuspect.apathy.core.wrapper.Defender;
import agency.highlysuspect.apathy.core.wrapper.LogFacade;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.nio.file.Path;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public abstract class Apathy {
    public static final String MODID = "apathy";
    public static Apathy instance;
    public final LogFacade log;
    public final NotRegistry<JsonSerializer<? extends Spec<Rule, ?>>> ruleSerializers = new NotRegistry();
    public final NotRegistry<JsonSerializer<? extends Spec<Partial, ?>>> partialSerializers = new NotRegistry();
    public CookedConfig generalCfg = CookedConfig.Unset.INSTANCE;
    public CookedConfig mobCfg = CookedConfig.Unset.INSTANCE;
    public CookedConfig bossCfg = CookedConfig.Unset.INSTANCE;
    public Rule configuredRule = RuleSpecAlways.ALWAYS_ALLOW.build();
    @Nullable
    public Rule jsonRule;

    public Apathy(LogFacade log) {
        if (instance != null) {
            IllegalStateException e = new IllegalStateException("Apathy instantiated twice!");
            log.error("Apathy instantiated twice!", e);
            throw e;
        }
        instance = this;
        this.log = log;
    }

    public void init() {
        this.addRules();
        ConfigSchema generalConfigSchema = new ConfigSchema();
        this.addGeneralConfig(generalConfigSchema);
        this.generalCfg = this.generalConfigBakery().cook(generalConfigSchema);
        ConfigSchema mobsConfigSchema = new ConfigSchema();
        this.addMobConfig(mobsConfigSchema);
        this.mobCfg = this.mobsConfigBakery().cook(mobsConfigSchema);
        ConfigSchema bossConfigSchema = new ConfigSchema();
        this.addBossConfig(bossConfigSchema);
        this.bossCfg = this.bossConfigBakery().cook(bossConfigSchema);
        this.installConfigFileReloader();
        this.installCommandRegistrationCallback();
        this.installPlayerSetManagerTicker();
    }

    public boolean allowedToTargetPlayer(Attacker attacker, Defender defender) {
        TriState result = (TriState)((Object)this.configuredRule.apply(attacker, defender));
        if (result != TriState.DEFAULT) {
            return result.get();
        }
        return this.mobCfg.get(CoreMobOptions.fallthrough);
    }

    public boolean refreshGeneralConfig() {
        return this.generalCfg.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshMobConfig() {
        boolean ok = this.mobCfg.refresh();
        Rule newConfiguredRule = this.configuredRule;
        try {
            newConfiguredRule = this.bakeMobsConfigRule();
        }
        catch (Exception e) {
            this.log.error("Problem baking rule: ", e);
            ok = false;
        }
        finally {
            this.configuredRule = newConfiguredRule;
        }
        Rule newJsonRule = this.jsonRule;
        try {
            newJsonRule = JsonRule.loadJson(this.mobsJsonPath());
        }
        catch (Exception e) {
            this.log.error("Problem reading mobs.json: ", e);
            ok = false;
        }
        finally {
            this.jsonRule = newJsonRule;
        }
        return ok;
    }

    public boolean refreshBossConfig() {
        return this.bossCfg.refresh();
    }

    public boolean refreshConfig() {
        boolean ok = this.refreshGeneralConfig();
        ok &= this.refreshMobConfig();
        return ok &= this.refreshBossConfig();
    }

    public void addRules() {
        this.ruleSerializers.register("always", RuleSpecAlways.Serializer.INSTANCE);
        this.ruleSerializers.register("chain", RuleSpecChain.Serializer.INSTANCE);
        this.ruleSerializers.register("debug", RuleSpecDebug.Serializer.INSTANCE);
        this.ruleSerializers.register("difficulty_case", RuleSpecDifficultyCase.Serializer.INSTANCE);
        this.ruleSerializers.register("evaluate_json_file", RuleSpecJson.Serializer.INSTANCE);
        this.ruleSerializers.register("if", RuleSpecIf.Serializer.INSTANCE);
        this.ruleSerializers.register("predicated", RuleSpecPredicated.Serializer.INSTANCE);
        this.partialSerializers.register("all", PartialSpecAll.Serializer.INSTANCE);
        this.partialSerializers.register("always", PartialSpecAlways.Serializer.INSTANCE);
        this.partialSerializers.register("any", PartialSpecAny.Serializer.INSTANCE);
        this.partialSerializers.register("attacker_is", PartialSpecAttackerIs.Serializer.INSTANCE);
        this.partialSerializers.register("attacker_is_boss", PartialSpecAttackerIsBoss.Serializer.INSTANCE);
        this.partialSerializers.register("attacker_tagged_with", PartialSpecAttackerTaggedWith.Serializer.INSTANCE);
        this.partialSerializers.register("difficulty_is", PartialSpecDifficultyIs.Serializer.INSTANCE);
        this.partialSerializers.register("not", PartialSpecNot.Serializer.INSTANCE);
        this.partialSerializers.register("random", PartialSpecRandom.Serializer.INSTANCE);
        this.partialSerializers.register("revenge_timer", PartialSpecRevengeTimer.Serializer.INSTANCE);
        this.partialSerializers.register("spawn_type", PartialSpecSpawnType.Serializer.INSTANCE);
        this.ruleSerializers.register("allow_if", RuleSpecPredicated.LegacyAllowIfSerializer.INSTANCE);
        this.ruleSerializers.register("deny_if", RuleSpecPredicated.LegacyDenyIfSerializer.INSTANCE);
    }

    public void addGeneralConfig(ConfigSchema schema) {
        CoreGenOptions.visit(schema);
    }

    public void addMobConfig(ConfigSchema schema) {
        CoreMobOptions.visit(schema);
    }

    public void addBossConfig(ConfigSchema schema) {
        CoreBossOptions.visit(schema);
    }

    public abstract ConfigSchema.Bakery generalConfigBakery();

    public abstract ConfigSchema.Bakery mobsConfigBakery();

    public abstract ConfigSchema.Bakery bossConfigBakery();

    public abstract Path mobsJsonPath();

    public abstract Path dumpsDirPath();

    public abstract Rule bakeMobsConfigRule();

    public abstract void installConfigFileReloader();

    public abstract void installCommandRegistrationCallback();

    public abstract void installPlayerSetManagerTicker();

    @Nullable
    public abstract AttackerType parseAttackerType(String var1);

    @Nullable
    public abstract AttackerTag parseAttackerTag(String var1);

    public Spec<Rule, ?> readRule(JsonElement jsonElem) {
        if (!(jsonElem instanceof JsonObject)) {
            throw new IllegalArgumentException("Expected json object, found " + (jsonElem == null ? "nothing" : jsonElem.getClass().getSimpleName()));
        }
        JsonObject json = (JsonObject)jsonElem;
        JsonPrimitive typeField = json.getAsJsonPrimitive("type");
        if (typeField == null) {
            throw new IllegalArgumentException("Expected json object to have field 'type', but didn't find any");
        }
        String type = typeField.getAsString();
        JsonSerializer<Spec<Rule, ?>> jsonSerializer = this.ruleSerializers.get(type);
        if (jsonSerializer == null) {
            StringBuilder message = new StringBuilder("No rule serializer with name '").append(type).append("'.");
            if (this.partialSerializers.names().contains(type)) {
                message.append("\n   (Apathy does have something named '").append(type).append("', but it's a predicate, not a rule.)");
            }
            message.append("\n   Valid rules are '");
            message.append(this.ruleSerializers.names().stream().sorted().collect(Collectors.joining("', '")));
            message.append("'.");
            throw new IllegalArgumentException(message.toString());
        }
        try {
            return jsonSerializer.read(json);
        }
        catch (Exception e) {
            throw JsonRule.context(e, "Problem decoding '" + type + "' rule:");
        }
    }

    public <T extends Spec<Rule, T>> JsonObject writeRule(Spec<Rule, T> rule) {
        JsonObject ok = new JsonObject();
        JsonSerializer<T> serializer = rule.getSerializer();
        String name = this.ruleSerializers.getName(serializer);
        if (name == null) {
            throw new IllegalArgumentException("internal error, unregistered rule serializer for " + serializer.getClass().getName());
        }
        ok.addProperty("type", name);
        serializer.writeErased(rule, ok);
        return ok;
    }

    public Spec<Partial, ?> readPartial(JsonElement jsonElem) {
        if (!(jsonElem instanceof JsonObject)) {
            throw new IllegalArgumentException("Expected json object, found " + (jsonElem == null ? "nothing" : jsonElem.getClass().getSimpleName()));
        }
        JsonObject json = (JsonObject)jsonElem;
        JsonPrimitive typeField = json.getAsJsonPrimitive("type");
        if (typeField == null) {
            throw new IllegalArgumentException("Expected json object to have field 'type', but didn't find any");
        }
        String type = typeField.getAsString();
        JsonSerializer<Spec<Partial, ?>> jsonSerializer = this.partialSerializers.get(type);
        if (jsonSerializer == null) {
            StringBuilder message = new StringBuilder("No predicate serializer with name '").append(type).append("'.");
            if (this.ruleSerializers.names().contains(type)) {
                message.append("\n  (Apathy does have something named '").append(type).append("', but it's a rule, not a predicate.)");
            }
            message.append("\n   Valid predicates are '");
            message.append(this.partialSerializers.names().stream().sorted().collect(Collectors.joining("', '")));
            message.append("'.");
            throw new IllegalArgumentException(message.toString());
        }
        try {
            return jsonSerializer.read(json);
        }
        catch (Exception e) {
            throw JsonRule.context(e, "Problem decoding '" + type + "' predicate:");
        }
    }

    public <T extends Spec<Partial, T>> JsonObject writePartial(Spec<Partial, T> part) {
        JsonObject ok = new JsonObject();
        JsonSerializer<T> serializer = part.getSerializer();
        String name = this.partialSerializers.getName(serializer);
        if (name == null) {
            throw new IllegalArgumentException("internal error, unregistered partial serializer for " + serializer.getClass().getName());
        }
        ok.addProperty("type", name);
        serializer.writeErased(part, ok);
        return ok;
    }
}

