/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.coreplusminecraft;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.CoreMobOptions;
import agency.highlysuspect.apathy.coreplusminecraft.ApathyPlusMinecraft;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class PlayerSetManagerGuts {
    private final Runnable setDirty;
    public final ConcurrentHashMap<String, Entry> playerSets = new ConcurrentHashMap();

    public PlayerSetManagerGuts(Runnable setDirty) {
        this.setDirty = setDirty;
    }

    public void load(CompoundTag tag) {
        this.playerSets.clear();
        CompoundTag allSets = tag.m_128469_("PlayerSets");
        for (String name : allSets.m_128431_()) {
            this.playerSets.put(name, Entry.fromTag(allSets.m_128469_(name)));
        }
    }

    public CompoundTag save(CompoundTag tag) {
        CompoundTag allSets = new CompoundTag();
        for (Map.Entry<String, Entry> entry : this.playerSets.entrySet()) {
            allSets.m_128365_(entry.getKey(), (Tag)entry.getValue().toTag());
        }
        tag.m_128365_("PlayerSets", (Tag)allSets);
        return tag;
    }

    public boolean playerInSet(ServerPlayer player, String name) {
        Entry set = this.playerSets.get(name);
        if (set == null) {
            return false;
        }
        return set.contains(player);
    }

    public void syncWithConfig() {
        Optional<String> configSetName = Apathy.instance.mobCfg.get(CoreMobOptions.playerSetName);
        if (configSetName.isPresent()) {
            String name = configSetName.get();
            boolean selfselectiness = Apathy.instance.mobCfg.get(CoreMobOptions.playerSetSelfSelect);
            Entry set = this.playerSets.get(name);
            if (set == null) {
                set = Entry.newEmpty(selfselectiness);
                this.playerSets.put(name, set);
                this.setDirty.run();
            }
            if (set.selfSelect != selfselectiness) {
                this.playerSets.put(name, set.withSelfSelect(selfselectiness));
                this.setDirty.run();
            }
        }
    }

    public JoinResult join(ServerPlayer player, String name, boolean op) {
        Entry set = this.playerSets.get(name);
        if (set == null) {
            return JoinResult.NO_SUCH_SET;
        }
        if (!op && !set.selfSelect()) {
            return JoinResult.NOT_SELF_SELECT;
        }
        if (set.contains(player)) {
            return JoinResult.ALREADY_IN_SET;
        }
        this.playerSets.put(name, set.withAddition(player));
        this.setDirty.run();
        return JoinResult.SUCCESS;
    }

    public PartResult part(ServerPlayer player, String name, boolean op) {
        Entry set = this.playerSets.get(name);
        if (set == null) {
            return PartResult.NO_SUCH_SET;
        }
        if (!op && !set.selfSelect()) {
            return PartResult.NOT_SELF_SELECT;
        }
        if (!set.contains(player)) {
            return PartResult.ALREADY_NOT_IN_SET;
        }
        this.playerSets.put(name, set.withRemoval(player));
        this.setDirty.run();
        return PartResult.SUCCESS;
    }

    public DeleteResult delete(String name) {
        Entry removed = this.playerSets.remove(name);
        if (removed == null) {
            return DeleteResult.NO_SUCH_SET;
        }
        this.setDirty.run();
        return DeleteResult.SUCCESS;
    }

    public EditResult edit(String name, boolean newSelfSelect) {
        Entry set = this.playerSets.get(name);
        if (set == null) {
            return EditResult.NO_SUCH_SET;
        }
        if (set.selfSelect && newSelfSelect) {
            return EditResult.ALREADY_SELF_SELECT;
        }
        if (!set.selfSelect && !newSelfSelect) {
            return EditResult.ALREADY_NOT_SELF_SELECT;
        }
        this.playerSets.put(name, set.withSelfSelect(newSelfSelect));
        this.setDirty.run();
        return EditResult.SUCCESS;
    }

    public CreateResult create(String name, boolean newSelfSelect) {
        if (this.playerSets.get(name) != null) {
            return CreateResult.ALREADY_EXISTS;
        }
        this.playerSets.put(name, Entry.newEmpty(newSelfSelect));
        this.setDirty.run();
        return CreateResult.SUCCESS;
    }

    public boolean isEmpty() {
        return this.playerSets.isEmpty();
    }

    public Set<Map.Entry<String, Entry>> entrySet() {
        return this.playerSets.entrySet();
    }

    public static CompletableFuture<Suggestions> suggestSelfSelectPlayerSets(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        PlayerSetManagerGuts guts = ApathyPlusMinecraft.instanceMinecraft.getFor(context);
        return SharedSuggestionProvider.m_82970_((Iterable)guts.playerSets.entrySet().stream().filter(entry -> ((Entry)entry.getValue()).selfSelect()).map(Map.Entry::getKey).collect(Collectors.toList()), (SuggestionsBuilder)builder);
    }

    public static CompletableFuture<Suggestions> suggestAllPlayerSets(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        PlayerSetManagerGuts guts = ApathyPlusMinecraft.instanceMinecraft.getFor(context);
        return SharedSuggestionProvider.m_82970_(new ArrayList(guts.playerSets.keySet()), (SuggestionsBuilder)builder);
    }

    public Component printAllPlayerSets() {
        return ApathyPlusMinecraft.instanceMinecraft.formatList(this.playerSets.entrySet(), entry -> ApathyPlusMinecraft.instanceMinecraft.literal((String)entry.getKey() + (((Entry)entry.getValue()).selfSelect() ? " (self-select)" : "")));
    }

    public static final class Entry {
        private final Set<UUID> members;
        private final boolean selfSelect;

        public Entry(Set<UUID> members, boolean selfSelect) {
            this.members = members;
            this.selfSelect = selfSelect;
        }

        public static Entry newEmpty(boolean selfSelect) {
            return new Entry(new HashSet<UUID>(), selfSelect);
        }

        public boolean contains(ServerPlayer player) {
            return this.members.contains(player.m_142081_());
        }

        public Entry withAddition(ServerPlayer newPlayer) {
            HashSet<UUID> members2 = new HashSet<UUID>(this.members);
            members2.add(newPlayer.m_142081_());
            return new Entry(members2, this.selfSelect);
        }

        public Entry withRemoval(ServerPlayer removePlayer) {
            HashSet<UUID> members2 = new HashSet<UUID>(this.members);
            members2.remove(removePlayer.m_142081_());
            return new Entry(members2, this.selfSelect);
        }

        public Entry withSelfSelect(boolean newSelfSelect) {
            return new Entry(this.members, newSelfSelect);
        }

        public static Entry fromTag(CompoundTag tag) {
            HashSet<UUID> members = new HashSet<UUID>();
            ListTag memberList = tag.m_128437_("Members", 11);
            for (Tag value : memberList) {
                members.add(NbtUtils.m_129233_((Tag)value));
            }
            return new Entry(members, tag.m_128471_("SelfSelect"));
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            ListTag memberList = new ListTag();
            for (UUID uuid : this.members) {
                memberList.add((Object)NbtUtils.m_129226_((UUID)uuid));
            }
            tag.m_128365_("Members", (Tag)memberList);
            tag.m_128379_("SelfSelect", this.selfSelect);
            return tag;
        }

        public Set<UUID> members() {
            return this.members;
        }

        public boolean selfSelect() {
            return this.selfSelect;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals(this.members, ((Entry)obj).members) && this.selfSelect == ((Entry)obj).selfSelect;
        }

        public int hashCode() {
            return this.members.hashCode() ^ (this.selfSelect ? Integer.MAX_VALUE : 0);
        }
    }

    public static enum JoinResult {
        SUCCESS,
        NO_SUCH_SET,
        ALREADY_IN_SET,
        NOT_SELF_SELECT;

    }

    public static enum PartResult {
        SUCCESS,
        NO_SUCH_SET,
        ALREADY_NOT_IN_SET,
        NOT_SELF_SELECT;

    }

    public static enum DeleteResult {
        SUCCESS,
        NO_SUCH_SET;

    }

    public static enum EditResult {
        SUCCESS,
        NO_SUCH_SET,
        ALREADY_SELF_SELECT,
        ALREADY_NOT_SELF_SELECT;

    }

    public static enum CreateResult {
        SUCCESS,
        ALREADY_EXISTS;

    }
}

