/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.mixin.dragon;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.CoreBossOptions;
import agency.highlysuspect.apathy.core.etc.PortalInitialState;
import agency.highlysuspect.apathy.core.wrapper.DragonDuck;
import agency.highlysuspect.apathy.coreplusminecraft.ApathyPlusMinecraft;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EndDragonFight.class})
public abstract class EndDragonFightMixin {
    @Shadow
    @Final
    private static Predicate<Entity> f_64059_;
    @Shadow
    @Final
    private ServerLevel f_64061_;
    @Shadow
    @Final
    private List<Integer> f_64062_;
    @Shadow
    private boolean f_64068_;
    @Shadow
    private boolean f_64069_;
    @Shadow
    private BlockPos f_64072_;
    @Shadow
    private List<EndCrystal> f_64075_;
    @Unique
    private int gatewayTimer = -100;
    @Unique
    private static final int NOT_RUNNING = -100;
    @Unique
    private static final String APATHY_GATEWAYTIMER = "apathy-gateway-timer";

    @Shadow
    protected abstract boolean m_64106_();

    @Shadow
    protected abstract void m_64109_();

    @Shadow
    protected abstract void m_64093_(boolean var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    void apathy$onInit(ServerLevel world, long l, CompoundTag tag, CallbackInfo ci) {
        this.gatewayTimer = tag.m_128441_(APATHY_GATEWAYTIMER) ? tag.m_128451_(APATHY_GATEWAYTIMER) : -100;
        if (tag.m_128425_("ExitPortalLocation", 10)) {
            this.f_64072_ = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("ExitPortalLocation"));
        }
    }

    @Inject(method={"saveData"}, at={@At(value="RETURN")})
    void apathy$whenTagging(CallbackInfoReturnable<CompoundTag> cir) {
        ((CompoundTag)cir.getReturnValue()).m_128405_(APATHY_GATEWAYTIMER, this.gatewayTimer);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    void apathy$tick(CallbackInfo ci) {
        if (!this.m_64106_()) {
            return;
        }
        if (this.gatewayTimer != -100 && this.f_64072_ != null) {
            if (this.gatewayTimer > 0) {
                --this.gatewayTimer;
            } else {
                this.doGatewaySpawn();
                this.gatewayTimer = -100;
            }
        }
        boolean simulacra = Apathy.instance.bossCfg.get(CoreBossOptions.simulacraDragonAdvancements);
        boolean startCalm = Apathy.instance.bossCfg.get(CoreBossOptions.dragonInitialState).isCalm();
        if (simulacra && startCalm) {
            EnderDragon rarrrh = (EnderDragon)EntityType.f_20565_.m_20615_((Level)this.f_64061_);
            for (ServerPlayer player : this.f_64061_.m_8795_(f_64059_)) {
                CriteriaTriggers.f_10568_.m_48104_(player, (Entity)rarrrh, ApathyPlusMinecraft.instanceMinecraft.comicalAnvilSound((Entity)rarrrh));
            }
        }
    }

    @Inject(method={"scanState"}, at={@At(value="RETURN")})
    void apathy$finishScanningState(CallbackInfo ci) {
        PortalInitialState portalInitialState;
        if (Apathy.instance.bossCfg.get(CoreBossOptions.dragonInitialState).isCalm()) {
            this.f_64068_ = true;
            this.f_64069_ = true;
        }
        if ((portalInitialState = Apathy.instance.bossCfg.get(CoreBossOptions.portalInitialState)).isOpenByDefault()) {
            this.m_64093_(true);
            if (portalInitialState.hasEgg()) {
                this.f_64061_.m_46597_(this.f_64061_.m_5452_(Heightmap.Types.MOTION_BLOCKING, EndPodiumFeature.f_65714_), Blocks.f_50260_.m_49966_());
            }
        }
        int initialEndGatewayCount = Apathy.instance.bossCfg.get(CoreBossOptions.initialEndGatewayCount);
        for (int i = 0; i < initialEndGatewayCount; ++i) {
            this.m_64109_();
        }
    }

    @Inject(method={"createNewDragon"}, at={@At(value="RETURN")})
    void apathy$whenCreatingDragon(CallbackInfoReturnable<EnderDragon> cir) {
        if (!this.f_64069_ && Apathy.instance.bossCfg.get(CoreBossOptions.dragonInitialState).isPassive()) {
            ((DragonDuck)cir.getReturnValue()).apathy$disallowAttackingPlayers();
        }
    }

    @Inject(method={"respawnDragon(Ljava/util/List;)V"}, at={@At(value="HEAD")}, cancellable=true)
    void apathy$whenBeginningRespawnSequence(List<EndCrystal> crystals, CallbackInfo ci) {
        switch (Apathy.instance.bossCfg.get(CoreBossOptions.resummonSequence)) {
            case DEFAULT: {
                break;
            }
            case DISABLED: {
                ci.cancel();
                break;
            }
            case SPAWN_GATEWAY: {
                ci.cancel();
                this.tryEnderCrystalGateway(crystals);
            }
        }
    }

    @Unique
    private void tryEnderCrystalGateway(List<EndCrystal> crystalsAroundEndPortal) {
        BlockPos pos;
        if (this.gatewayTimer == -100 && (pos = this.gatewayDryRun()) != null) {
            BlockPos downABit = pos.m_6625_(2);
            for (EndCrystal crystal : crystalsAroundEndPortal) {
                crystal.m_31052_(downABit);
            }
            this.f_64075_ = crystalsAroundEndPortal;
            this.gatewayTimer = 100;
        }
    }

    @Unique
    private void doGatewaySpawn() {
        this.m_64109_();
        BlockPos exitPos = this.f_64072_;
        BlockPos oneAboveThat = exitPos.m_7494_();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            for (EndCrystal crystal : this.f_64061_.m_45976_(EndCrystal.class, new AABB(oneAboveThat.m_5484_(d, 2)))) {
                crystal.m_31052_(null);
                ApathyPlusMinecraft.instanceMinecraft.explodeNoBlockInteraction((Level)this.f_64061_, (Entity)crystal, crystal.m_20185_(), crystal.m_20186_(), crystal.m_20189_(), 6.0f);
                crystal.m_146870_();
            }
        }
        if (Apathy.instance.bossCfg.get(CoreBossOptions.simulacraDragonAdvancements).booleanValue()) {
            EnderDragon dummy = (EnderDragon)EntityType.f_20565_.m_20615_((Level)this.f_64061_);
            for (ServerPlayer player : this.f_64061_.m_8795_(f_64059_)) {
                CriteriaTriggers.f_10580_.m_68256_(player, (Entity)dummy);
            }
        }
    }

    @Unique
    @Nullable
    private BlockPos gatewayDryRun() {
        if (this.f_64062_.isEmpty()) {
            return null;
        }
        int i = this.f_64062_.get(this.f_64062_.size() - 1);
        int j = Mth.m_14107_((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
        int k = Mth.m_14107_((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
        return new BlockPos(j, 75, k);
    }
}

