/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.coreplusminecraft;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.CoreGenOptions;
import agency.highlysuspect.apathy.core.CoreMobOptions;
import agency.highlysuspect.apathy.core.JsonRule;
import agency.highlysuspect.apathy.core.TriState;
import agency.highlysuspect.apathy.core.config.ConfigSchema;
import agency.highlysuspect.apathy.core.rule.PartialSpecAttackerIs;
import agency.highlysuspect.apathy.core.rule.PartialSpecAttackerIsBoss;
import agency.highlysuspect.apathy.core.rule.PartialSpecAttackerTaggedWith;
import agency.highlysuspect.apathy.core.rule.PartialSpecDifficultyIs;
import agency.highlysuspect.apathy.core.rule.PartialSpecRevengeTimer;
import agency.highlysuspect.apathy.core.rule.PartialSpecSpawnType;
import agency.highlysuspect.apathy.core.rule.Rule;
import agency.highlysuspect.apathy.core.rule.RuleSpecAlways;
import agency.highlysuspect.apathy.core.rule.RuleSpecChain;
import agency.highlysuspect.apathy.core.rule.RuleSpecJson;
import agency.highlysuspect.apathy.core.rule.RuleSpecPredicated;
import agency.highlysuspect.apathy.core.rule.Spec;
import agency.highlysuspect.apathy.core.wrapper.Attacker;
import agency.highlysuspect.apathy.core.wrapper.AttackerType;
import agency.highlysuspect.apathy.core.wrapper.Defender;
import agency.highlysuspect.apathy.coreplusminecraft.MinecraftConv;
import agency.highlysuspect.apathy.coreplusminecraft.MinecraftMobOptions;
import agency.highlysuspect.apathy.coreplusminecraft.PlayerSetManagerGuts;
import agency.highlysuspect.apathy.coreplusminecraft.rule.PartialSpecDefenderHasAdvancement;
import agency.highlysuspect.apathy.coreplusminecraft.rule.PartialSpecDefenderInPlayerSet;
import agency.highlysuspect.apathy.coreplusminecraft.rule.PartialSpecEffect;
import agency.highlysuspect.apathy.coreplusminecraft.rule.PartialSpecLocation;
import agency.highlysuspect.apathy.coreplusminecraft.rule.PartialSpecScore;
import agency.highlysuspect.apathy.coreplusminecraft.rule.PartialSpecScoreboardTeam;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public abstract class ApathyPlusMinecraft
extends Apathy {
    public static ApathyPlusMinecraft instanceMinecraft;

    public ApathyPlusMinecraft() {
        super(MinecraftConv.toLogFacade(LogManager.getLogger((String)"apathy")));
        if (instanceMinecraft != null) {
            IllegalStateException e = new IllegalStateException("Apathy instanceMinecraft instantiated twice!");
            this.log.error("Apathy instanceMinecraft instantiated twice!", e);
            throw e;
        }
        instanceMinecraft = this;
    }

    public abstract Registry<MobEffect> mobEffectRegistry();

    public abstract Registry<EntityType<?>> entityTypeRegistry();

    public abstract BlockPos blockPosContaining(double var1, double var3, double var5);

    public abstract Component literal(String var1);

    public abstract String stringifyComponent(Component var1);

    public abstract <T> Component formatList(Collection<T> var1, Function<T, Component> var2);

    public abstract PlayerSetManagerGuts getFor(MinecraftServer var1);

    public PlayerSetManagerGuts getFor(CommandContext<CommandSourceStack> ctx) {
        return this.getFor(((CommandSourceStack)ctx.getSource()).m_81377_());
    }

    public abstract DamageSource comicalAnvilSound(Entity var1);

    public abstract void explodeNoBlockInteraction(Level var1, Entity var2, double var3, double var5, double var7, float var9);

    public abstract void sendSuccess(CommandContext<CommandSourceStack> var1, Supplier<Component> var2, boolean var3);

    public abstract ServerLevel serverLevel(Entity var1);

    @Override
    public Rule bakeMobsConfigRule() {
        Spec<Rule, RuleSpecAlways> ruleSpec;
        if (this.mobCfg.get(CoreMobOptions.nuclearOption).booleanValue()) {
            Apathy.instance.log.info("Nuclear option enabled - Ignoring ALL rules in the config file", new Object[0]);
            ruleSpec = RuleSpecAlways.ALWAYS_DENY;
        } else {
            ArrayList ruleSpecList = new ArrayList();
            block22: for (String ruleName : this.mobCfg.get(CoreMobOptions.ruleOrder)) {
                switch (ruleName.trim().toLowerCase(Locale.ROOT)) {
                    case "json": {
                        ruleSpecList.add(new RuleSpecJson());
                        continue block22;
                    }
                    case "difficulty": {
                        ruleSpecList.add(new RuleSpecPredicated(this.mobCfg.get(CoreMobOptions.difficultySetIncluded), this.mobCfg.get(CoreMobOptions.difficultySetExcluded), new PartialSpecDifficultyIs(this.mobCfg.get(CoreMobOptions.difficultySet))));
                        continue block22;
                    }
                    case "boss": {
                        ruleSpecList.add(new RuleSpecPredicated(this.mobCfg.get(CoreMobOptions.boss), TriState.DEFAULT, PartialSpecAttackerIsBoss.INSTANCE));
                        continue block22;
                    }
                    case "mobset": {
                        ruleSpecList.add(new RuleSpecPredicated(this.mobCfg.get(CoreMobOptions.mobSetIncluded), this.mobCfg.get(CoreMobOptions.mobSetExcluded), new PartialSpecAttackerIs(this.mobCfg.get(CoreMobOptions.mobSet))));
                        continue block22;
                    }
                    case "tagset": {
                        ruleSpecList.add(new RuleSpecPredicated(this.mobCfg.get(CoreMobOptions.tagSetIncluded), this.mobCfg.get(CoreMobOptions.tagSetExcluded), new PartialSpecAttackerTaggedWith(this.mobCfg.get(CoreMobOptions.tagSet))));
                        continue block22;
                    }
                    case "playerset": {
                        this.mobCfg.get(CoreMobOptions.playerSetName).ifPresent(s -> ruleSpecList.add(new RuleSpecPredicated(this.mobCfg.get(CoreMobOptions.playerSetIncluded), this.mobCfg.get(CoreMobOptions.playerSetExcluded), new PartialSpecDefenderInPlayerSet(Collections.singleton(s)))));
                        continue block22;
                    }
                    case "potionset": {
                        ruleSpecList.add(new RuleSpecPredicated(this.mobCfg.get(MinecraftMobOptions.mobEffectSetIncluded), this.mobCfg.get(MinecraftMobOptions.mobEffectSetExcluded), new PartialSpecEffect(this.mobCfg.get(MinecraftMobOptions.mobEffectSet), this.mobCfg.get(MinecraftMobOptions.mobEffectWho))));
                        continue block22;
                    }
                    case "spawntype": {
                        ruleSpecList.add(new RuleSpecPredicated(this.mobCfg.get(CoreMobOptions.spawnTypeIncluded), this.mobCfg.get(CoreMobOptions.spawnTypeExcluded), new PartialSpecSpawnType(this.mobCfg.get(CoreMobOptions.spawnTypeSet))));
                        continue block22;
                    }
                    case "revenge": {
                        ruleSpecList.add(new RuleSpecPredicated(TriState.TRUE, TriState.DEFAULT, new PartialSpecRevengeTimer(this.mobCfg.get(CoreMobOptions.revengeTimer))));
                        continue block22;
                    }
                }
                Apathy.instance.log.warn("Unknown rule " + ruleName + " listed in the ruleOrder config option.", new Object[0]);
            }
            ruleSpec = new RuleSpecChain(ruleSpecList);
        }
        if (this.generalCfg.get(CoreGenOptions.debugBuiltinRule).booleanValue()) {
            JsonRule.dump(ruleSpec, "builtin-rule");
        }
        if (this.generalCfg.get(CoreGenOptions.runRuleOptimizer).booleanValue()) {
            ruleSpec = ruleSpec.optimize();
            if (this.generalCfg.get(CoreGenOptions.debugBuiltinRule).booleanValue()) {
                JsonRule.dump(ruleSpec, "builtin-rule-opt");
            }
        }
        return ruleSpec.build();
    }

    public boolean allowedToTargetPlayer(Mob attacker, ServerPlayer player) {
        return this.allowedToTargetPlayer((Attacker)attacker, (Defender)player);
    }

    @Override
    public void addRules() {
        super.addRules();
        this.partialSerializers.register("advancements", PartialSpecDefenderHasAdvancement.Serializer.INSTANCE);
        this.partialSerializers.register("effect", PartialSpecEffect.Serializer.INSTANCE);
        this.partialSerializers.register("in_player_set", PartialSpecDefenderInPlayerSet.Serializer.INSTANCE);
        this.partialSerializers.register("location", PartialSpecLocation.Serializer.INSTANCE);
        this.partialSerializers.register("score", PartialSpecScore.Serializer.INSTANCE);
        this.partialSerializers.register("team", PartialSpecScoreboardTeam.Serializer.INSTANCE);
    }

    @Override
    public void addMobConfig(ConfigSchema schema) {
        super.addMobConfig(schema);
        MinecraftMobOptions.visit(schema);
    }

    @Override
    @Nullable
    public AttackerType parseAttackerType(String s) {
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        ResourceLocation rl = ResourceLocation.m_135820_((String)s);
        if (rl == null) {
            this.log.error("Can't parse '{}' as a resourcelocation", s);
            return null;
        }
        EntityType type = (EntityType)this.entityTypeRegistry().m_7745_(rl);
        return (AttackerType)type;
    }
}

