/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.coreplusminecraft.rule;

import agency.highlysuspect.apathy.core.TriState;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Partial;
import agency.highlysuspect.apathy.core.rule.PartialSpecAlways;
import agency.highlysuspect.apathy.core.rule.Spec;
import agency.highlysuspect.apathy.core.wrapper.VecThree;
import agency.highlysuspect.apathy.coreplusminecraft.ApathyPlusMinecraft;
import agency.highlysuspect.apathy.coreplusminecraft.MinecraftConv;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Map;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;

public class PartialSpecLocation
implements Spec<Partial, PartialSpecLocation> {
    private final LocationPredicate pred;
    private final LocationGetter who;
    private final String uniqueId;
    private final int offsetX;
    private final int offsetY;
    private final int offsetZ;

    public PartialSpecLocation(LocationPredicate pred, LocationGetter who, String uniqueId, int offsetX, int offsetY, int offsetZ) {
        this.pred = pred;
        this.who = who;
        this.uniqueId = uniqueId;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    @Override
    public Spec<Partial, ?> optimize() {
        if (this.pred == LocationPredicate.f_52592_) {
            return PartialSpecAlways.TRUE;
        }
        return this;
    }

    @Override
    public Partial build() {
        return (attacker, defender) -> {
            ServerLevel slevel = MinecraftConv.level(defender);
            Vec3 attackerPos = MinecraftConv.mob(attacker).m_20182_();
            Vec3 defenderPos = MinecraftConv.player(defender).m_20182_();
            switch (this.who) {
                case ATTACKER: {
                    return this.test(slevel, this.pred, attackerPos.f_82479_, attackerPos.f_82480_, attackerPos.f_82481_);
                }
                case DEFENDER: {
                    return this.test(slevel, this.pred, defenderPos.f_82479_, defenderPos.f_82480_, defenderPos.f_82481_);
                }
                case ATTACKER_SPAWN_LOCATION: {
                    Map<String, TriState> cache = attacker.apathy$getOrCreateLocationPredicateCache();
                    TriState cachedResult = cache.getOrDefault(this.uniqueId, TriState.DEFAULT);
                    if (cachedResult == TriState.TRUE) {
                        return true;
                    }
                    if (cachedResult == TriState.FALSE) {
                        return false;
                    }
                    VecThree vecThree = attacker.apathy$getSpawnPosition();
                    if (vecThree == null) {
                        return false;
                    }
                    if (slevel.m_46749_(ApathyPlusMinecraft.instanceMinecraft.blockPosContaining(vecThree.x(), vecThree.y(), vecThree.z()))) {
                        boolean result = this.test(slevel, this.pred, vecThree.x(), vecThree.y(), vecThree.z());
                        cache.put(this.uniqueId, TriState.fromBoolean(result));
                        return result;
                    }
                    return false;
                }
            }
            return false;
        };
    }

    private boolean test(ServerLevel slevel, LocationPredicate pred, double x, double y, double z) {
        return pred.m_52617_(slevel, x + (double)this.offsetX, y + (double)this.offsetY, z + (double)this.offsetZ);
    }

    @Override
    public JsonSerializer<PartialSpecLocation> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static enum LocationGetter {
        ATTACKER,
        ATTACKER_SPAWN_LOCATION,
        DEFENDER;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static LocationGetter fromString(String name) {
            switch (name.toLowerCase(Locale.ROOT)) {
                case "attacker": {
                    return ATTACKER;
                }
                case "attacker_spawn_location": {
                    return ATTACKER_SPAWN_LOCATION;
                }
                case "defender": {
                    return DEFENDER;
                }
            }
            throw new IllegalArgumentException("expected 'attacker', 'defender', or 'attacker_spawn_location");
        }
    }

    public static class Serializer
    implements JsonSerializer<PartialSpecLocation> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void write(PartialSpecLocation thing, JsonObject json) {
            json.add("predicate", thing.pred.m_52616_());
            json.addProperty("who", thing.who.toString());
            json.addProperty("uniqueId", thing.uniqueId);
            if (thing.offsetX != 0) {
                json.addProperty("offsetX", (Number)thing.offsetX);
            }
            if (thing.offsetY != 0) {
                json.addProperty("offsetY", (Number)thing.offsetY);
            }
            if (thing.offsetZ != 0) {
                json.addProperty("offsetZ", (Number)thing.offsetZ);
            }
        }

        @Override
        public PartialSpecLocation read(JsonObject json) {
            LocationPredicate pred = LocationPredicate.m_52629_((JsonElement)json.get("predicate"));
            LocationGetter who = json.has("who") ? LocationGetter.fromString(json.get("who").getAsString()) : LocationGetter.ATTACKER_SPAWN_LOCATION;
            String uniqueId = json.has("uniqueId") ? json.get("uniqueId").getAsString() : "defaultUniqueId";
            int offsetX = json.has("offsetX") ? json.get("offsetX").getAsInt() : 0;
            int offsetY = json.has("offsetY") ? json.get("offsetY").getAsInt() : 0;
            int offsetZ = json.has("offsetZ") ? json.get("offsetZ").getAsInt() : 0;
            return new PartialSpecLocation(pred, who, uniqueId, offsetX, offsetY, offsetZ);
        }
    }
}

