/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.mixin.dragon;

import agency.highlysuspect.apathy.EndDragonFightExt;
import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.CoreBossOptions;
import agency.highlysuspect.apathy.core.etc.PortalInitialState;
import agency.highlysuspect.apathy.core.wrapper.DragonDuck;
import agency.highlysuspect.apathy.coreplusminecraft.ApathyPlusMinecraft;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EndDragonFight.class})
public abstract class EndDragonFightMixin {
    @Shadow
    @Final
    private Predicate<Entity> f_286991_;
    @Shadow
    @Final
    private ServerLevel f_64061_;
    @Shadow
    @Final
    private BlockPos f_286985_;
    @Shadow
    @Final
    private ObjectArrayList<Integer> f_64062_;
    @Shadow
    private boolean f_64068_;
    @Shadow
    private boolean f_64069_;
    @Shadow
    private BlockPos f_64072_;
    @Shadow
    private List<EndCrystal> f_64075_;
    @Unique
    EndDragonFightExt ext;
    @Unique
    private boolean apathyIsManagingTheInitialPortalVanillaDontLookPlease = false;

    @Shadow
    protected abstract boolean m_64106_();

    @Shadow
    protected abstract void m_64109_();

    @Shadow
    protected abstract void m_64093_(boolean var1);

    @Inject(method={"<init>(Lnet/minecraft/server/level/ServerLevel;JLnet/minecraft/world/level/dimension/end/EndDragonFight$Data;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="TAIL")})
    void apathy$onInit(ServerLevel slevel, long $$1, EndDragonFight.Data $$2, BlockPos $$3, CallbackInfo ci) {
        this.ext = EndDragonFightExt.get(slevel);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    void apathy$dontTick(CallbackInfo ci) {
        if (!this.m_64106_()) {
            return;
        }
        if (!this.ext.hasCompletedInitialSetup()) {
            PortalInitialState portalInitialState = Apathy.instance.bossCfg.get(CoreBossOptions.portalInitialState);
            if (portalInitialState.isOpenByDefault()) {
                this.m_64093_(true);
                if (portalInitialState.hasEgg()) {
                    this.f_64061_.m_46597_(this.f_64061_.m_5452_(Heightmap.Types.MOTION_BLOCKING, EndPodiumFeature.m_287210_((BlockPos)this.f_286985_)), Blocks.f_50260_.m_49966_());
                }
            }
            int initialEndGatewayCount = Apathy.instance.bossCfg.get(CoreBossOptions.initialEndGatewayCount);
            for (int i = 0; i < initialEndGatewayCount; ++i) {
                this.m_64109_();
            }
            this.ext.markInitialSetupCompleted();
        }
        if (this.f_64072_ != null && this.ext.tickTimer()) {
            this.doGatewaySpawn();
        }
        boolean simulacra = Apathy.instance.bossCfg.get(CoreBossOptions.simulacraDragonAdvancements);
        boolean startCalm = Apathy.instance.bossCfg.get(CoreBossOptions.dragonInitialState).isCalm();
        if (simulacra && startCalm) {
            EnderDragon rarrrh = (EnderDragon)EntityType.f_20565_.m_20615_((Level)this.f_64061_);
            for (ServerPlayer player : this.f_64061_.m_8795_(this.f_286991_)) {
                CriteriaTriggers.f_10568_.m_48104_(player, (Entity)rarrrh, ApathyPlusMinecraft.instanceMinecraft.comicalAnvilSound((Entity)rarrrh));
            }
        }
    }

    @Inject(method={"scanState"}, at={@At(value="HEAD")})
    void apathy$startScanningState(CallbackInfo ci) {
        this.apathyIsManagingTheInitialPortalVanillaDontLookPlease = Apathy.instance.bossCfg.get(CoreBossOptions.portalInitialState) != PortalInitialState.CLOSED;
    }

    @Inject(method={"scanState"}, at={@At(value="RETURN")})
    void apathy$finishScanningState(CallbackInfo ci) {
        this.apathyIsManagingTheInitialPortalVanillaDontLookPlease = false;
        if (Apathy.instance.bossCfg.get(CoreBossOptions.dragonInitialState).isCalm()) {
            this.f_64068_ = true;
            this.f_64069_ = true;
        }
    }

    @Inject(method={"hasActiveExitPortal"}, at={@At(value="HEAD")}, cancellable=true)
    void apathy$bopActiveExitPortal(CallbackInfoReturnable<Boolean> cir) {
        if (this.apathyIsManagingTheInitialPortalVanillaDontLookPlease) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"createNewDragon"}, at={@At(value="RETURN")})
    void apathy$whenCreatingDragon(CallbackInfoReturnable<EnderDragon> cir) {
        if (!this.f_64069_ && Apathy.instance.bossCfg.get(CoreBossOptions.dragonInitialState).isPassive()) {
            ((DragonDuck)cir.getReturnValue()).apathy$disallowAttackingPlayers();
        }
    }

    @Inject(method={"respawnDragon"}, at={@At(value="HEAD")}, cancellable=true)
    void apathy$whenBeginningRespawnSequence(List<EndCrystal> crystals, CallbackInfo ci) {
        switch (Apathy.instance.bossCfg.get(CoreBossOptions.resummonSequence)) {
            case DEFAULT: {
                break;
            }
            case SPAWN_GATEWAY: {
                this.tryEnderCrystalGateway(crystals);
            }
            case DISABLED: {
                ci.cancel();
            }
        }
    }

    @Unique
    private void tryEnderCrystalGateway(List<EndCrystal> crystalsAroundEndPortal) {
        BlockPos pos;
        if (!this.ext.gatewayTimerRunning() && (pos = this.gatewayDryRun()) != null) {
            BlockPos downABit = pos.m_6625_(2);
            for (EndCrystal crystal : crystalsAroundEndPortal) {
                crystal.m_31052_(downABit);
            }
            this.f_64075_ = crystalsAroundEndPortal;
            this.ext.setGatewayTimer(100);
        }
    }

    @Unique
    private void doGatewaySpawn() {
        this.m_64109_();
        BlockPos exitPos = this.f_64072_;
        BlockPos oneAboveThat = exitPos.m_7494_();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            for (EndCrystal crystal : this.f_64061_.m_45976_(EndCrystal.class, new AABB(oneAboveThat.m_5484_(d, 2)))) {
                crystal.m_31052_(null);
                ApathyPlusMinecraft.instanceMinecraft.explodeNoBlockInteraction((Level)this.f_64061_, (Entity)crystal, crystal.m_20185_(), crystal.m_20186_(), crystal.m_20189_(), 6.0f);
                crystal.m_146870_();
            }
        }
        if (Apathy.instance.bossCfg.get(CoreBossOptions.simulacraDragonAdvancements).booleanValue()) {
            EnderDragon dummy = (EnderDragon)EntityType.f_20565_.m_20615_((Level)this.f_64061_);
            for (ServerPlayer player : this.f_64061_.m_8795_(this.f_286991_)) {
                CriteriaTriggers.f_10580_.m_68256_(player, (Entity)dummy);
            }
        }
    }

    @Unique
    @Nullable
    private BlockPos gatewayDryRun() {
        if (this.f_64062_.isEmpty()) {
            return null;
        }
        int i = (Integer)this.f_64062_.get(this.f_64062_.size() - 1);
        int j = Mth.m_14107_((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
        int k = Mth.m_14107_((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
        return new BlockPos(j, 75, k);
    }
}

