/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.repo.constants;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.repo.NEURepositoryException;
import io.github.moulberry.repo.util.NEUId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EssenceCosts {
    Map<@NEUId String, EssenceCost> costs = new HashMap<String, EssenceCost>();

    public EssenceCosts(JsonObject json) throws NEURepositoryException {
        try {
            for (Map.Entry costs : json.entrySet()) {
                JsonElement costThing;
                EssenceCost essenceCost = new EssenceCost();
                JsonElement value = (JsonElement)costs.getValue();
                JsonObject object = value.getAsJsonObject();
                essenceCost.type = object.get("type").getAsString();
                essenceCost.essenceCosts = new HashMap<Integer, Integer>();
                int i = 1;
                while ((costThing = object.get(i + "")) != null) {
                    int cost = costThing.getAsInt();
                    essenceCost.essenceCosts.put(i, cost);
                    ++i;
                }
                essenceCost.itemCosts = new HashMap<Integer, List<String>>();
                if (object.has("items")) {
                    JsonObject items = object.getAsJsonObject("items");
                    for (Map.Entry itemCost : items.entrySet()) {
                        JsonArray itemCostList = ((JsonElement)itemCost.getValue()).getAsJsonArray();
                        ArrayList<String> itemCostListTrans = new ArrayList<String>();
                        for (JsonElement jsonElement : itemCostList) {
                            itemCostListTrans.add(jsonElement.getAsString());
                        }
                        essenceCost.itemCosts.put(Integer.parseInt((String)itemCost.getKey()), itemCostListTrans);
                    }
                }
                this.costs.put((String)costs.getKey(), essenceCost);
            }
        }
        catch (ClassCastException | NumberFormatException e) {
            throw new NEURepositoryException("constants/essencecosts.json", "Invalid JSON Syntax", e);
        }
    }

    public Map<@NEUId String, EssenceCost> getCosts() {
        return this.costs;
    }

    public static class EssenceCost {
        String type;
        Map<Integer, Integer> essenceCosts;
        Map<Integer, List<String>> itemCosts;

        private EssenceCost() {
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setEssenceCosts(Map<Integer, Integer> essenceCosts) {
            this.essenceCosts = essenceCosts;
        }

        public void setItemCosts(Map<Integer, List<String>> itemCosts) {
            this.itemCosts = itemCosts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EssenceCost)) {
                return false;
            }
            EssenceCost other = (EssenceCost)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Map<Integer, Integer> this$essenceCosts = this.getEssenceCosts();
            Map<Integer, Integer> other$essenceCosts = other.getEssenceCosts();
            if (this$essenceCosts == null ? other$essenceCosts != null : !((Object)this$essenceCosts).equals(other$essenceCosts)) {
                return false;
            }
            Map<Integer, List<String>> this$itemCosts = this.getItemCosts();
            Map<Integer, List<String>> other$itemCosts = other.getItemCosts();
            return !(this$itemCosts == null ? other$itemCosts != null : !((Object)this$itemCosts).equals(other$itemCosts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EssenceCost;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Map<Integer, Integer> $essenceCosts = this.getEssenceCosts();
            result = result * 59 + ($essenceCosts == null ? 43 : ((Object)$essenceCosts).hashCode());
            Map<Integer, List<String>> $itemCosts = this.getItemCosts();
            result = result * 59 + ($itemCosts == null ? 43 : ((Object)$itemCosts).hashCode());
            return result;
        }

        public String toString() {
            return "EssenceCosts.EssenceCost(type=" + this.getType() + ", essenceCosts=" + this.getEssenceCosts() + ", itemCosts=" + this.getItemCosts() + ")";
        }

        public String getType() {
            return this.type;
        }

        public Map<Integer, Integer> getEssenceCosts() {
            return this.essenceCosts;
        }

        public Map<Integer, List<String>> getItemCosts() {
            return this.itemCosts;
        }
    }
}

