/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.networth;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.function.ToDoubleFunction;
import net.azureaaron.networth.Calculation;
import net.azureaaron.networth.NetworthResult;
import net.azureaaron.networth.data.ModifierValues;
import net.azureaaron.networth.item.PetInfo;
import net.azureaaron.networth.utils.PetConstants;

public class PetCalculator {
    private PetCalculator() {
    }

    public static NetworthResult calculate(PetInfo info, ToDoubleFunction<String> prices, ModifierValues modifiers) {
        Calculation calculation;
        int incrementalLevel;
        double price;
        if (info.equals(PetInfo.EMPTY)) {
            return NetworthResult.EMPTY;
        }
        double lvl1 = prices.applyAsDouble("LVL_1_" + info.tier() + "_" + info.type());
        double lvl100 = prices.applyAsDouble("LVL_100_" + info.tier() + "_" + info.type());
        double lvl200 = prices.applyAsDouble("LVL_200_" + info.tier() + "_" + info.type());
        if (lvl1 == 0.0 || lvl100 == 0.0 && !info.type().equals("GOLDEN_DRAGON")) {
            return NetworthResult.EMPTY;
        }
        ArrayList<Calculation> calculations = new ArrayList<Calculation>();
        IntIntPair levelInfo = PetCalculator.calculatePetLevel(info);
        int level = levelInfo.leftInt();
        int maxXp = levelInfo.rightInt();
        double d = price = lvl200 != 0.0 ? lvl200 : lvl100;
        if (level < 100 && maxXp != 0) {
            double baseFormula = (lvl100 - lvl1) / (double)maxXp;
            price = baseFormula * info.xp() + lvl1;
        }
        if (level > 100 && level < 200 && (incrementalLevel = level % (int)Math.pow(10.0, (int)Math.log10(level))) != 1) {
            double baseFormula = (lvl200 - lvl100) / 100.0;
            price = baseFormula * (double)incrementalLevel + lvl100;
        }
        double base = price;
        if (info.skin().isPresent()) {
            calculation = Calculation.of(Calculation.Type.SKIN, info.skin().get(), prices.applyAsDouble("PET_SKIN_" + info.skin().get()) * modifiers.regular().getDouble((Object)"skins"));
            price += calculation.price();
            calculations.add(calculation);
        }
        if (info.heldItem().isPresent()) {
            calculation = Calculation.of(Calculation.Type.PET_ITEM, info.heldItem().get(), prices.applyAsDouble(info.heldItem().get()) * modifiers.regular().getDouble((Object)"petItem"));
            price += calculation.price();
            calculations.add(calculation);
        }
        int maxPetXpFromCandy = info.candies() * 1000000;
        double xpWithoutCandy = info.xp() - (double)maxPetXpFromCandy;
        if (info.candies() > 0 && !PetConstants.BLOCKED_CANDY_REDUCTION_PETS.contains(info.type()) && xpWithoutCandy < (double)maxXp) {
            double reducedValue = price * modifiers.regular().getDouble((Object)"petCandy");
            price = Math.max(reducedValue, price - (double)(level == 100 ? 5000000 : 2500000));
        }
        return NetworthResult.of(price, base, calculations);
    }

    public static IntIntPair calculatePetLevel(PetInfo info) {
        String petTier = info.heldItem().orElse("").equals("PET_ITEM_TIER_BOOST") ? PetConstants.PET_RARITIES.get(PetConstants.PET_RARITIES.indexOf(info.tier()) + 1) : info.tier();
        int maxPetLevel = PetConstants.SPECIAL_MAX_LVLS.getOrDefault((Object)info.type(), 100);
        int petOffset = PetConstants.RARITY_OFFSETS.getInt((Object)(info.type().equals("BINGO") ? "COMMON" : petTier));
        IntArrayList petLevels = new IntArrayList(PetConstants.PET_LEVELS.subList(petOffset, petOffset + maxPetLevel - 1));
        int level = 1;
        int totalXp = 0;
        IntListIterator intListIterator = petLevels.iterator();
        while (intListIterator.hasNext()) {
            int lvlXp = (Integer)intListIterator.next();
            if ((double)(totalXp += lvlXp) > info.xp()) {
                totalXp -= lvlXp;
                break;
            }
            ++level;
        }
        return IntIntPair.of((int)Math.min(level, maxPetLevel), (int)petLevels.intStream().sum());
    }
}

