/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.deps.moulconfig.deps.libninepatch;

import java.util.Objects;
import net.azureaaron.dandelion.deps.moulconfig.deps.libninepatch.ContextualTextureRenderer;
import net.azureaaron.dandelion.deps.moulconfig.deps.libninepatch.TextureRegion;
import net.azureaaron.dandelion.deps.moulconfig.deps.libninepatch.TextureRenderer;
import org.jetbrains.annotations.Nullable;

public final class NinePatch<T> {
    private final TextureRegion<T> texture;
    private final int cornerWidth;
    private final int cornerHeight;
    private final float cornerU;
    private final float cornerV;
    @Nullable
    private final Integer tileWidth;
    @Nullable
    private final Integer tileHeight;
    private final Mode mode;

    NinePatch(Builder<T> builder) {
        this.texture = ((Builder)builder).texture;
        this.cornerWidth = ((Builder)builder).cornerWidth;
        this.cornerHeight = ((Builder)builder).cornerHeight;
        this.cornerU = ((Builder)builder).cornerU;
        this.cornerV = ((Builder)builder).cornerV;
        this.tileWidth = ((Builder)builder).tileWidth;
        this.tileHeight = ((Builder)builder).tileHeight;
        this.mode = ((Builder)builder).mode;
        if (!(this.mode != Mode.TILING || this.cornerWidth != 0 && this.cornerHeight != 0 || this.tileWidth != null && this.tileHeight != null)) {
            throw new IllegalArgumentException("Tile size must be specified when corner size is 0");
        }
    }

    public <C> void draw(ContextualTextureRenderer<? super T, C> renderer, C context, int width, int height) {
        if (this.mode == Mode.TILING) {
            this.drawTiling(renderer, context, width, height);
        } else {
            this.drawStretching(renderer, context, width, height);
        }
        this.drawCorners(renderer, context, width, height);
    }

    public void draw(TextureRenderer<? super T> renderer, int width, int height) {
        this.draw(renderer, null, width, height);
    }

    private boolean hasCorners() {
        return this.cornerWidth > 0 && this.cornerHeight > 0 && this.cornerU > 0.0f & this.cornerV > 0.0f;
    }

    private <C> void drawCorners(ContextualTextureRenderer<? super T, C> renderer, C context, int width, int height) {
        if (!this.hasCorners()) {
            return;
        }
        renderer.draw(this.texture, context, 0, 0, this.cornerWidth, this.cornerHeight, 0.0f, 0.0f, this.cornerU, this.cornerV);
        renderer.draw(this.texture, context, width - this.cornerWidth, 0, this.cornerWidth, this.cornerHeight, 1.0f - this.cornerU, 0.0f, 1.0f, this.cornerV);
        renderer.draw(this.texture, context, 0, height - this.cornerHeight, this.cornerWidth, this.cornerHeight, 0.0f, 1.0f - this.cornerV, this.cornerU, 1.0f);
        renderer.draw(this.texture, context, width - this.cornerWidth, height - this.cornerHeight, this.cornerWidth, this.cornerHeight, 1.0f - this.cornerU, 1.0f - this.cornerV, 1.0f, 1.0f);
    }

    private <C> void drawTiling(ContextualTextureRenderer<? super T, C> renderer, C context, int width, int height) {
        float u1 = this.cornerU;
        float v1 = this.cornerV;
        float u2 = 1.0f - this.cornerU;
        float v2 = 1.0f - this.cornerV;
        int tileWidth = this.tileWidth == null ? (int)((float)this.cornerWidth / this.cornerU * (u2 - u1)) : this.tileWidth;
        int tileHeight = this.tileHeight == null ? (int)((float)this.cornerHeight / this.cornerV * (v2 - v1)) : this.tileHeight;
        renderer.drawTiled(this.texture, context, this.cornerWidth, this.cornerHeight, width - 2 * this.cornerWidth, height - 2 * this.cornerHeight, tileWidth, tileHeight, u1, v1, u2, v2);
        if (this.hasCorners()) {
            int regionHeight = height - 2 * this.cornerHeight;
            int y = this.cornerHeight;
            renderer.drawTiled(this.texture, context, 0, y, this.cornerWidth, regionHeight, this.cornerWidth, tileHeight, 0.0f, v1, this.cornerU, v2);
            renderer.drawTiled(this.texture, context, width - this.cornerWidth, y, this.cornerWidth, regionHeight, this.cornerWidth, tileHeight, 1.0f - this.cornerU, v1, 1.0f, v2);
            int regionWidth = width - 2 * this.cornerWidth;
            int x = this.cornerWidth;
            renderer.drawTiled(this.texture, context, x, 0, regionWidth, this.cornerHeight, tileWidth, this.cornerHeight, u1, 0.0f, u2, this.cornerV);
            renderer.drawTiled(this.texture, context, x, height - this.cornerHeight, regionWidth, this.cornerHeight, tileWidth, this.cornerHeight, u1, 1.0f - this.cornerV, u2, 1.0f);
        }
    }

    private <C> void drawStretching(ContextualTextureRenderer<? super T, C> renderer, C context, int width, int height) {
        int w = width - 2 * this.cornerWidth;
        int h = height - 2 * this.cornerHeight;
        float u = this.cornerU;
        float v = this.cornerV;
        if (this.hasCorners()) {
            renderer.draw(this.texture, context, this.cornerWidth, 0, w, this.cornerHeight, u, 0.0f, 1.0f - u, v);
            renderer.draw(this.texture, context, 0, this.cornerHeight, this.cornerWidth, h, 0.0f, v, u, 1.0f - v);
            renderer.draw(this.texture, context, this.cornerWidth, height - this.cornerHeight, w, this.cornerHeight, u, 1.0f - v, 1.0f - u, 1.0f);
            renderer.draw(this.texture, context, width - this.cornerWidth, this.cornerHeight, this.cornerWidth, h, 1.0f - u, v, 1.0f, 1.0f - v);
        }
        renderer.draw(this.texture, context, this.cornerWidth, this.cornerHeight, w, h, u, v, 1.0f - u, 1.0f - v);
    }

    static float lerp(float delta, float a, float b) {
        return a + delta * (b - a);
    }

    public static <T> Builder<T> builder(T texture) {
        return NinePatch.builder(new TextureRegion<T>(texture, 0.0f, 0.0f, 1.0f, 1.0f));
    }

    public static <T> Builder<T> builder(TextureRegion<T> texture) {
        return new Builder(texture);
    }

    public static final class Builder<T> {
        private final TextureRegion<T> texture;
        private int cornerWidth = 0;
        private int cornerHeight = 0;
        private float cornerU = 0.0f;
        private float cornerV = 0.0f;
        @Nullable
        private Integer tileWidth = null;
        @Nullable
        private Integer tileHeight = null;
        private Mode mode = Mode.TILING;

        private Builder(TextureRegion<T> texture) {
            this.texture = Objects.requireNonNull(texture, "texture");
        }

        public Builder<T> cornerSize(int width, int height) {
            this.cornerWidth = width;
            this.cornerHeight = height;
            return this;
        }

        public Builder<T> cornerSize(int size) {
            return this.cornerSize(size, size);
        }

        public Builder<T> cornerUv(float u, float v) {
            this.cornerU = u;
            this.cornerV = v;
            return this;
        }

        public Builder<T> cornerUv(float uv) {
            return this.cornerUv(uv, uv);
        }

        public Builder<T> tileSize(int width, int height) {
            this.tileWidth = width;
            this.tileHeight = height;
            return this;
        }

        public Builder<T> tileSize(int size) {
            return this.tileSize(size, size);
        }

        public Builder<T> mode(Mode mode) {
            this.mode = Objects.requireNonNull(mode, "mode");
            return this;
        }

        public NinePatch<T> build() {
            return new NinePatch(this);
        }
    }

    public static enum Mode {
        TILING,
        STRETCHING;

    }
}

