/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.deps.moulconfig.gui;

import net.azureaaron.dandelion.deps.moulconfig.gui.GuiComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiContext;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiElement;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiImmediateContext;
import net.azureaaron.dandelion.deps.moulconfig.gui.KeyboardEvent;
import net.azureaaron.dandelion.deps.moulconfig.gui.MouseEvent;
import net.azureaaron.dandelion.deps.moulconfig.internal.Warnings;
import org.jetbrains.annotations.NotNull;

public final class GuiElementComponent
extends GuiComponent {
    private final GuiElement element;

    @Override
    public void setContext(GuiContext context) {
        super.setContext(context);
        if (context.getRoot() != this) {
            Warnings.warn("Mounting GuiElementComponent at location other than root. This can cause issues.");
        }
    }

    @Override
    public int getWidth() {
        return this.mc.getScaledWidth();
    }

    @Override
    public int getHeight() {
        return this.mc.getScaledHeight();
    }

    @Override
    public void render(@NotNull GuiImmediateContext context) {
        if (context.getRenderOffsetX() != 0 || context.getRenderOffsetY() != 0) {
            Warnings.warn("Cannot render GuiElement with a pretransformed matrix stack");
        }
        this.element.render();
    }

    @Override
    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
        return this.element.mouseInput(context.getMouseX(), context.getMouseY(), mouseEvent);
    }

    @Override
    public boolean keyboardEvent(@NotNull KeyboardEvent event, @NotNull GuiImmediateContext context) {
        return this.element.keyboardInput(event);
    }

    public GuiElementComponent(GuiElement element) {
        this.element = element;
    }

    public GuiElement getElement() {
        return this.element;
    }

    public String toString() {
        return "GuiElementComponent(element=" + this.getElement() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiElementComponent)) {
            return false;
        }
        GuiElementComponent other = (GuiElementComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GuiElement this$element = this.getElement();
        GuiElement other$element = other.getElement();
        return !(this$element == null ? other$element != null : !this$element.equals(other$element));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiElementComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        GuiElement $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : $element.hashCode());
        return result;
    }
}

