/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.deps.moulconfig.gui.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Pair;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiImmediateContext;
import net.azureaaron.dandelion.deps.moulconfig.gui.KeyboardEvent;
import net.azureaaron.dandelion.deps.moulconfig.gui.MouseEvent;
import net.azureaaron.dandelion.deps.moulconfig.observer.GetSetter;
import net.azureaaron.dandelion.deps.moulconfig.observer.ObservableList;

public class ArrayComponent<T>
extends GuiComponent {
    public final ObservableList<T> list;
    public final Function<? super T, ? extends GuiComponent> render;
    public final Supplier<Color> oddRows;
    public final Supplier<Color> evenRows;
    public List<GuiComponent> guiElements;
    public IdentityHashMap<T, GuiComponent> cache = new IdentityHashMap();
    private int width;
    private int height;

    public ArrayComponent(ObservableList<T> list, Function<? super T, ? extends GuiComponent> render) {
        this(list, render, GetSetter.constant(new Color(0, true)), GetSetter.constant(new Color(0, true)));
    }

    public ArrayComponent(ObservableList<T> list, Function<? super T, ? extends GuiComponent> render, Supplier<Color> oddRows, Supplier<Color> evenRows) {
        this.list = list;
        this.render = render;
        this.oddRows = oddRows;
        this.evenRows = evenRows;
        list.setObserver(this::reinitializeChildren);
        this.reinitializeChildren();
    }

    public void reinitializeChildren() {
        this.width = 0;
        this.height = 0;
        this.guiElements = new ArrayList<GuiComponent>();
        for (T t : this.list) {
            GuiComponent apply = this.cache.computeIfAbsent(t, this.render);
            apply.foldRecursive(null, (guiComponent, unused) -> {
                guiComponent.setContext(this.getContext());
                return null;
            });
            apply.setContext(this.getContext());
            this.width = Math.max(apply.getWidth(), this.width);
            this.height += apply.getHeight();
            this.guiElements.add(apply);
        }
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor) {
        for (GuiComponent guiElement : this.guiElements) {
            initial = visitor.apply(guiElement, (GuiComponent)initial);
        }
        return initial;
    }

    public void foldWithContext(GuiImmediateContext context, ContextVisitor visitor) {
        this.foldChildren(new Pair((Object)0, (Object)0), (child, position) -> {
            visitor.onContext((GuiComponent)child, context.translated(0, (Integer)position.getFirst(), child.getWidth(), child.getHeight()), (Integer)position.getSecond());
            return new Pair((Object)(child.getHeight() + (Integer)position.getFirst()), (Object)((Integer)position.getSecond() + 1));
        });
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().pushMatrix();
        this.foldWithContext(context, (child, childContext, index) -> {
            Color color = (index % 2 == 0 ? this.evenRows : this.oddRows).get();
            childContext.getRenderContext().drawColoredRect(0.0f, 0.0f, childContext.getWidth(), child.getHeight(), color.getRGB());
            child.render(childContext);
            context.getRenderContext().translate(0.0f, child.getHeight());
        });
        context.getRenderContext().popMatrix();
    }

    @Override
    public boolean mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context) {
        boolean[] wasHandled = new boolean[1];
        this.foldWithContext(context, (guiComponent, guiImmediateContext, index) -> {
            if (guiComponent.mouseEvent(mouseEvent, guiImmediateContext)) {
                wasHandled[0] = true;
            }
        });
        return wasHandled[0];
    }

    @Override
    public boolean keyboardEvent(KeyboardEvent keyboardEvent, GuiImmediateContext context) {
        boolean[] wasHandled = new boolean[1];
        this.foldWithContext(context, (guiComponent, guiImmediateContext, index) -> {
            if (!wasHandled[0] && guiComponent.keyboardEvent(keyboardEvent, guiImmediateContext)) {
                wasHandled[0] = true;
            }
        });
        return wasHandled[0];
    }

    public ObservableList<T> getList() {
        return this.list;
    }

    public Function<? super T, ? extends GuiComponent> getRender() {
        return this.render;
    }

    public Supplier<Color> getOddRows() {
        return this.oddRows;
    }

    public Supplier<Color> getEvenRows() {
        return this.evenRows;
    }

    public List<GuiComponent> getGuiElements() {
        return this.guiElements;
    }

    public IdentityHashMap<T, GuiComponent> getCache() {
        return this.cache;
    }

    @FunctionalInterface
    public static interface ContextVisitor {
        public void onContext(GuiComponent var1, GuiImmediateContext var2, int var3);
    }
}

