/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.deps.moulconfig.gui.component;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiImmediateContext;
import net.azureaaron.dandelion.deps.moulconfig.gui.KeyboardEvent;
import net.azureaaron.dandelion.deps.moulconfig.gui.MouseEvent;

public class RowComponent
extends GuiComponent {
    final List<GuiComponent> children;

    public RowComponent(List<GuiComponent> children) {
        this.children = children;
    }

    public RowComponent(GuiComponent ... children) {
        this(Arrays.asList(children));
    }

    @Override
    public int getWidth() {
        return this.foldChildren(0, (child, width) -> child.getWidth() + width);
    }

    @Override
    public int getHeight() {
        return this.foldChildren(0, (child, height) -> Math.max(child.getHeight(), height));
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor) {
        for (GuiComponent child : this.children) {
            initial = visitor.apply(child, (GuiComponent)initial);
        }
        return initial;
    }

    public void foldWithContext(GuiImmediateContext context, BiConsumer<GuiComponent, GuiImmediateContext> visitor) {
        int height = context.getHeight();
        this.foldChildren(0, (child, position) -> {
            visitor.accept((GuiComponent)child, context.translated((int)position, 0, child.getWidth(), height));
            return child.getWidth() + position;
        });
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().pushMatrix();
        this.foldWithContext(context, (child, childContext) -> {
            child.render((GuiImmediateContext)childContext);
            context.getRenderContext().translate(child.getWidth(), 0.0f);
        });
        context.getRenderContext().popMatrix();
    }

    @Override
    public boolean mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context) {
        boolean[] wasHandled = new boolean[1];
        this.foldWithContext(context, (guiComponent, guiImmediateContext) -> {
            if (guiComponent.mouseEvent(mouseEvent, (GuiImmediateContext)guiImmediateContext)) {
                wasHandled[0] = true;
            }
        });
        return wasHandled[0];
    }

    @Override
    public boolean keyboardEvent(KeyboardEvent event, GuiImmediateContext context) {
        boolean[] wasHandled = new boolean[1];
        this.foldWithContext(context, (guiComponent, guiImmediateContext) -> {
            if (guiComponent.keyboardEvent(event, (GuiImmediateContext)guiImmediateContext)) {
                wasHandled[0] = true;
            }
        });
        return wasHandled[0];
    }

    public String toString() {
        return "RowComponent(children=" + this.children + ")";
    }
}

