/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.deps.moulconfig.gui.editors;

import java.lang.reflect.Type;
import net.azureaaron.dandelion.deps.moulconfig.ChromaColour;
import net.azureaaron.dandelion.deps.moulconfig.GuiTextures;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiImmediateContext;
import net.azureaaron.dandelion.deps.moulconfig.gui.MouseEvent;
import net.azureaaron.dandelion.deps.moulconfig.gui.component.ColorSelectComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.editors.ComponentEditor;
import net.azureaaron.dandelion.deps.moulconfig.internal.ColourUtil;
import net.azureaaron.dandelion.deps.moulconfig.processor.ProcessedOption;
import org.jetbrains.annotations.NotNull;

public class GuiOptionEditorColour
extends ComponentEditor {
    private final boolean usesString;
    GuiComponent component;

    public GuiOptionEditorColour(ProcessedOption option) {
        super(option);
        Type type = option.getType();
        if (type.equals(String.class)) {
            this.usesString = true;
        } else if (type.equals(ChromaColour.class)) {
            this.usesString = false;
        } else {
            throw new IllegalArgumentException("ConfigEditorColour may only be used on a String or ChromaColour field, but is used on " + option.getDebugDeclarationLocation());
        }
        this.component = this.wrapComponent(new GuiComponent(){

            @Override
            public int getWidth() {
                return 48;
            }

            @Override
            public int getHeight() {
                return 16;
            }

            @Override
            public void render(@NotNull GuiImmediateContext context) {
                int argb = GuiOptionEditorColour.this.get().getEffectiveColour().getRGB();
                context.getRenderContext().drawComplexTexture(GuiTextures.BUTTON_WHITE, 0.0f, 0.0f, context.getWidth(), context.getHeight(), it -> it.color(ColourUtil.makeOpaque(argb)));
            }

            @Override
            public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
                MouseEvent.Click click;
                if (mouseEvent instanceof MouseEvent.Click && (click = (MouseEvent.Click)mouseEvent).getMouseState() && click.getMouseButton() == 0 && context.isHovered()) {
                    ColorSelectComponent colorSelectComponent = new ColorSelectComponent(0, 0, GuiOptionEditorColour.this.get().toLegacyString(), newString -> GuiOptionEditorColour.this.set((String)newString), () -> GuiOptionEditorColour.this.closeOverlay());
                    int scaledHeight = context.getRenderContext().getMinecraft().getScaledHeight();
                    int clampedY = context.getAbsoluteMouseY() + colorSelectComponent.getHeight() > scaledHeight ? scaledHeight - colorSelectComponent.getHeight() : context.getAbsoluteMouseY();
                    GuiOptionEditorColour.this.openOverlay(colorSelectComponent, context.getAbsoluteMouseX(), clampedY);
                    return true;
                }
                return false;
            }
        });
    }

    ChromaColour get() {
        Object value = this.option.get();
        if (this.usesString) {
            return ChromaColour.forLegacyString((String)value);
        }
        return (ChromaColour)value;
    }

    void set(String newString) {
        if (this.usesString) {
            this.option.set(newString);
        } else {
            this.option.set(ChromaColour.forLegacyString(newString));
        }
    }

    @Override
    @NotNull
    public GuiComponent getDelegate() {
        return this.component;
    }
}

