/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.deps.moulconfig.observer;

import java.util.function.Function;
import net.azureaaron.dandelion.deps.moulconfig.observer.BaseObservable;
import net.azureaaron.dandelion.deps.moulconfig.observer.Observable;
import net.azureaaron.dandelion.deps.moulconfig.observer.Observer;

public class MapObservable<T, V>
extends BaseObservable<V>
implements Observer<T> {
    V value;
    Observable<T> root;
    Function<T, V> mapper;

    MapObservable(Observable<T> root, Function<T, V> mapper) {
        this.root = root;
        this.mapper = mapper;
        this.value = mapper.apply(root.get());
        root.addObserver(this);
    }

    @Override
    public V get() {
        return this.value;
    }

    @Override
    public void observeChange(T oldT, T newT) {
        V oldV = this.value;
        this.value = this.mapper.apply(newT);
        this.notifyObservers(oldV, this.value);
    }
}

