/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.deps.moulconfig.processor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.azureaaron.dandelion.deps.moulconfig.common.text.StructuredText;
import net.azureaaron.dandelion.deps.moulconfig.internal.Warnings;
import net.azureaaron.dandelion.deps.moulconfig.processor.HasDebugLocation;
import net.azureaaron.dandelion.deps.moulconfig.processor.ProcessedOption;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface ProcessedCategory
extends HasDebugLocation {
    public StructuredText getDisplayName();

    public StructuredText getDescription();

    public String getIdentifier();

    @Nullable
    public String getParentCategoryId();

    public @Unmodifiable List<? extends ProcessedOption> getOptions();

    public @Unmodifiable Map<? extends Integer, ? extends ProcessedOption> getAccordionAnchors();

    public static <T extends ProcessedCategory> @Unmodifiable LinkedHashMap<String, T> collect(Iterable<? extends T> categories) {
        LinkedHashMap<String, ProcessedCategory> map = new LinkedHashMap<String, ProcessedCategory>();
        String lastParentId = null;
        for (ProcessedCategory category : categories) {
            if (map.containsKey(category.getIdentifier())) {
                Warnings.warn("Category list contains multiple categories with identifier " + category.getIdentifier());
            }
            if (category.getParentCategoryId() == null) {
                lastParentId = category.getParentCategoryId();
            } else if (!category.getParentCategoryId().equals(lastParentId)) {
                Warnings.warn("Out of order child category " + category + " has parent with id " + category.getParentCategoryId() + " but the last parent was " + lastParentId);
            }
            map.put(category.getIdentifier(), category);
        }
        return map;
    }
}

