/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.impl;

import java.awt.Color;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.azureaaron.dandelion.impl.OptionBindingImpl;
import net.azureaaron.dandelion.impl.utils.ReflectionUtils;
import net.azureaaron.dandelion.systems.Option;
import net.azureaaron.dandelion.systems.OptionBinding;
import net.azureaaron.dandelion.systems.OptionFlag;
import net.azureaaron.dandelion.systems.OptionListener;
import net.azureaaron.dandelion.systems.controllers.BooleanController;
import net.azureaaron.dandelion.systems.controllers.ColourController;
import net.azureaaron.dandelion.systems.controllers.Controller;
import net.azureaaron.dandelion.systems.controllers.EnumController;
import net.azureaaron.dandelion.systems.controllers.FloatController;
import net.azureaaron.dandelion.systems.controllers.IntegerController;
import net.azureaaron.dandelion.systems.controllers.ItemController;
import net.azureaaron.dandelion.systems.controllers.StringController;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class OptionImpl<T>
implements Option<T> {
    @Nullable
    private final class_2960 id;
    private final class_2561 name;
    private final List<class_2561> description;
    private final List<class_2561> tags;
    private final OptionBinding<T> binding;
    private final Controller<T> controller;
    private final boolean modifiable;
    private final List<OptionFlag> flags;
    private final List<OptionListener<T>> listeners;
    private final Class<T> type;

    protected OptionImpl(@Nullable class_2960 id, class_2561 name, List<class_2561> description, List<class_2561> tags, OptionBinding<T> binding, Controller<T> controller, boolean modifiable, List<OptionFlag> flags, List<OptionListener<T>> listeners) {
        this.id = id;
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.description = Objects.requireNonNull(description, "description must not be null");
        this.tags = Objects.requireNonNull(tags, "tags must not be null");
        this.binding = Objects.requireNonNull(binding, "binding must not be null");
        this.controller = Objects.requireNonNull(controller, "controller must not be null");
        this.modifiable = modifiable;
        this.flags = Objects.requireNonNull(flags, "flags must not be null");
        this.listeners = Objects.requireNonNull(listeners, "listeners must not be null");
        this.type = ReflectionUtils.getActualClass(Objects.requireNonNull(this.binding.defaultValue(), "the default value of an option must not be null"));
        OptionImpl.checkType(this);
    }

    @Override
    @Nullable
    public class_2960 id() {
        return this.id;
    }

    @Override
    public class_2561 name() {
        return this.name;
    }

    @Override
    public List<class_2561> description() {
        return this.description;
    }

    @Override
    public List<class_2561> tags() {
        return this.tags;
    }

    @Override
    public OptionBinding<T> binding() {
        return this.binding;
    }

    @Override
    public Controller<T> controller() {
        return this.controller;
    }

    @Override
    public boolean modifiable() {
        return this.modifiable;
    }

    @Override
    public List<OptionFlag> flags() {
        return this.flags;
    }

    @Override
    public List<OptionListener<T>> listeners() {
        return this.listeners;
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    protected static <T> void checkType(Option<T> option) {
        boolean hasCorrectType;
        Controller<Color> colourController;
        Controller<T> controller = option.controller();
        Objects.requireNonNull(controller);
        Controller<T> controller2 = controller;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanController.class, ColourController.class, EnumController.class, FloatController.class, IntegerController.class, ItemController.class, StringController.class}, controller2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                boolean bl;
                BooleanController booleanController = (BooleanController)controller2;
                if (option.type() == Boolean.TYPE || option.type() == Boolean.class) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                boolean bl;
                colourController = (ColourController)controller2;
                if (option.type() == Color.class) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                EnumController enumController = (EnumController)controller2;
                boolean bl = option.type().isEnum();
                break;
            }
            case 3: {
                boolean bl;
                FloatController floatController = (FloatController)controller2;
                if (option.type() == Float.TYPE || option.type() == Float.class) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                boolean bl;
                IntegerController integerController = (IntegerController)controller2;
                if (option.type() == Integer.TYPE || option.type() == Integer.class) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                ItemController itemController = (ItemController)controller2;
                boolean bl = class_1792.class.isAssignableFrom(option.type());
                break;
            }
            case 6: {
                StringController stringController = (StringController)controller2;
                boolean bl = hasCorrectType = option.type() == String.class;
            }
        }
        if (!hasCorrectType) {
            String name = option.id() != null ? option.id().toString() : option.name().getString();
            Class<?> controllerInterfaceType = option.controller().getClass().getInterfaces()[0];
            Controller<T> controller3 = option.controller();
            Objects.requireNonNull(controller3);
            colourController = controller3;
            int n2 = 0;
            String expected = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanController.class, ColourController.class, EnumController.class, FloatController.class, IntegerController.class, ItemController.class, StringController.class}, (Object)colourController, n2)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    BooleanController booleanController = (BooleanController)colourController;
                    yield "boolean";
                }
                case 1 -> {
                    Controller<Color> colourController = colourController;
                    yield "Color";
                }
                case 2 -> {
                    EnumController enumController = (EnumController)colourController;
                    yield "Enum";
                }
                case 3 -> {
                    FloatController floatController = (FloatController)colourController;
                    yield "float";
                }
                case 4 -> {
                    IntegerController integerController = (IntegerController)colourController;
                    yield "int";
                }
                case 5 -> {
                    ItemController itemController = (ItemController)colourController;
                    yield "Item";
                }
                case 6 -> {
                    StringController stringController = (StringController)colourController;
                    yield "String";
                }
            };
            String message = String.format("[Dandelion] Option %s has mismatched type with controller (%s)! Expected a %s but got %s!", name, controllerInterfaceType, expected, option.type());
            throw new RuntimeException(message);
        }
    }

    public static class OptionBuilderImpl<T>
    implements Option.Builder<T> {
        private class_2960 id = null;
        private class_2561 name = class_2561.method_43473();
        private List<class_2561> description = List.of();
        private List<class_2561> tags = List.of();
        private OptionBinding<T> binding = null;
        private Controller<T> controller = null;
        private boolean modifiable = true;
        private List<OptionFlag> flags = List.of();
        private List<OptionListener<T>> listeners = new ArrayList<OptionListener<T>>();

        @Override
        public Option.Builder<T> id(class_2960 id) {
            this.id = id;
            return this;
        }

        @Override
        public Option.Builder<T> name(class_2561 name) {
            this.name = name;
            return this;
        }

        @Override
        public Option.Builder<T> description(class_2561 ... texts) {
            this.description = List.of(texts);
            return this;
        }

        @Override
        public Option.Builder<T> tags(class_2561 ... tags) {
            this.tags = List.of(tags);
            return this;
        }

        @Override
        public Option.Builder<T> binding(T defaultValue, Supplier<T> getter, Consumer<T> setter) {
            this.binding = new OptionBindingImpl<T>(defaultValue, getter, setter);
            return this;
        }

        @Override
        public Option.Builder<T> controller(Controller<T> controller) {
            this.controller = controller;
            return this;
        }

        @Override
        public Option.Builder<T> modifiable(boolean modifiable) {
            this.modifiable = modifiable;
            return this;
        }

        @Override
        public Option.Builder<T> flags(OptionFlag ... flags) {
            this.flags = List.of(flags);
            return this;
        }

        @Override
        public Option.Builder<T> listener(OptionListener<T> listener) {
            this.listeners.add(listener);
            return this;
        }

        @Override
        public Option<T> build() {
            return new OptionImpl<T>(this.id, this.name, this.description, this.tags, this.binding, this.controller, this.modifiable, this.flags, List.copyOf(this.listeners));
        }
    }
}

