/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.moulconfig.editor;

import java.awt.Color;
import net.azureaaron.dandelion.deps.moulconfig.ChromaColour;
import net.azureaaron.dandelion.deps.moulconfig.GuiTextures;
import net.azureaaron.dandelion.deps.moulconfig.common.MyResourceLocation;
import net.azureaaron.dandelion.deps.moulconfig.common.RenderContext;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiImmediateContext;
import net.azureaaron.dandelion.deps.moulconfig.gui.MouseEvent;
import net.azureaaron.dandelion.deps.moulconfig.gui.component.ColorSelectComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.editors.ComponentEditor;
import net.azureaaron.dandelion.deps.moulconfig.observer.GetSetter;
import net.azureaaron.dandelion.deps.moulconfig.processor.ProcessedOption;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

public class DandelionColourEditor
extends ComponentEditor {
    private static final MyResourceLocation ALPHA_BUTTON = new MyResourceLocation("dandelion", "textures/gui/button_alpha.png");
    private static final MyResourceLocation ALPHA_BUTTON_OVERLAY = new MyResourceLocation("dandelion", "textures/gui/button_alpha_overlay.png");
    private final GuiComponent component;

    public DandelionColourEditor(ProcessedOption option, boolean hasAlpha) {
        super(option);
        this.component = this.wrapComponent(new ColourOverlayComponent(this, option.intoProperty(), hasAlpha));
    }

    @Override
    @NotNull
    public GuiComponent getDelegate() {
        return this.component;
    }

    protected static class ColourOverlayComponent
    extends GuiComponent {
        private final DandelionColourEditor editor;
        private final GetSetter<Color> getSetter;
        private final boolean hasAlpha;

        protected ColourOverlayComponent(DandelionColourEditor editor, GetSetter<Color> getSetter, boolean hasAlpha) {
            this.editor = editor;
            this.getSetter = getSetter;
            this.hasAlpha = hasAlpha;
        }

        @Override
        public int getWidth() {
            return 48;
        }

        @Override
        public int getHeight() {
            return 16;
        }

        @Override
        public void render(@NotNull GuiImmediateContext context) {
            int colour = this.getSetter.get().getRGB();
            RenderContext renderContext = context.getRenderContext();
            if (this.hasAlpha) {
                renderContext.drawComplexTexture(ALPHA_BUTTON, 0.0f, 0.0f, context.getWidth(), context.getHeight(), block -> block.color(-1));
                renderContext.drawComplexTexture(ALPHA_BUTTON_OVERLAY, 0.0f, 0.0f, context.getWidth(), context.getHeight(), block -> block.color(colour));
            } else {
                renderContext.drawComplexTexture(GuiTextures.BUTTON_WHITE, 0.0f, 0.0f, context.getWidth(), context.getHeight(), block -> block.color(class_9848.method_61334((int)colour)));
            }
        }

        @Override
        public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
            MouseEvent.Click click;
            if (mouseEvent instanceof MouseEvent.Click && (click = (MouseEvent.Click)mouseEvent).getMouseState() && click.getMouseButton() == 0 && context.isHovered()) {
                ColorSelectComponent component = new ColorSelectComponent(0, 0, this.toChromaColour().toLegacyString(), this::fromChromaColourString, this.editor::closeOverlay, this.hasAlpha, true);
                int scaledHeight = context.getRenderContext().getMinecraft().getScaledHeight();
                int clampedY = context.getAbsoluteMouseY() + component.getHeight() > scaledHeight ? scaledHeight - component.getHeight() : context.getAbsoluteMouseY();
                this.editor.openOverlay(component, context.getAbsoluteMouseX(), clampedY);
                return true;
            }
            return false;
        }

        private ChromaColour toChromaColour() {
            Color colour = this.getSetter.get();
            return ChromaColour.fromStaticRGB(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getAlpha());
        }

        private void fromChromaColourString(String colourString) {
            Color colour = new Color(ChromaColour.specialToSimpleRGB(colourString), true);
            this.getSetter.set(colour);
        }
    }
}

