/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.moulconfig.editor;

import net.azureaaron.dandelion.deps.moulconfig.common.IMinecraft;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.component.TextFieldComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.editors.ComponentEditor;
import net.azureaaron.dandelion.deps.moulconfig.observer.GetSetter;
import net.azureaaron.dandelion.deps.moulconfig.processor.ProcessedOption;
import org.jetbrains.annotations.NotNull;

public class DandelionNumberFieldEditor
extends ComponentEditor {
    private final GuiComponent component;
    private String lastText = "";

    public DandelionNumberFieldEditor(final ProcessedOption option, final float minValue, final float maxValue, final float defaultValue) {
        super(option);
        GetSetter<String> getSetter = new GetSetter<String>(){

            @Override
            public String get() {
                return DandelionNumberFieldEditor.this.lastText;
            }

            @Override
            public void set(String newValue) {
                DandelionNumberFieldEditor.this.lastText = newValue;
                option.set(Float.valueOf(DandelionNumberFieldEditor.parseNumber(newValue, minValue, maxValue, defaultValue)));
            }
        };
        this.lastText = DandelionNumberFieldEditor.toString((Float)option.get());
        this.component = this.wrapComponent(new TextFieldComponent(getSetter, 80, () -> true, "", IMinecraft.INSTANCE.getDefaultFontRenderer()));
    }

    private static String toString(Float floatValue) {
        int intValue = floatValue.intValue();
        float convertedBackToFloat = intValue;
        if (convertedBackToFloat == floatValue.floatValue()) {
            return Integer.toString(intValue);
        }
        return floatValue.toString();
    }

    private static float parseNumber(String input, float minValue, float maxValue, float defaultValue) {
        try {
            return Math.clamp(Float.parseFloat(input), minValue, maxValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    @NotNull
    public GuiComponent getDelegate() {
        return this.component;
    }
}

