/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.legacyitemdfu.fixers;

import com.google.common.base.Splitter;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.azureaaron.legacyitemdfu.TypeReferences;
import net.azureaaron.legacyitemdfu.fixers.BannerPatternFormatFix;
import net.azureaaron.legacyitemdfu.fixers.fixes.TextFixes;
import net.azureaaron.legacyitemdfu.schemas.IdentifierNormalizingSchema;
import org.jetbrains.annotations.Nullable;

public class ItemStackComponentizationFix
extends DataFix {
    private static final int HIDE_ENCHANTMENTS_FLAG = 1;
    private static final int HIDE_MODIFIERS_FLAG = 2;
    private static final int HIDE_UNBREAKABLE_FLAG = 4;
    private static final int HIDE_CAN_DESTROY_FLAG = 8;
    private static final int HIDE_CAN_PLACE_FLAG = 16;
    private static final int HIDE_ADDITIONAL_FLAG = 32;
    private static final int HIDE_DYED_FLAG = 64;
    private static final int HIDE_UPGRADE_FLAG = 128;
    private static final Set<String> POTION_ITEM_IDS = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");
    private static final Set<String> ENTITY_BUCKET_ITEM_IDS = Set.of("minecraft:pufferfish_bucket", "minecraft:salmon_bucket", "minecraft:cod_bucket", "minecraft:tropical_fish_bucket", "minecraft:axolotl_bucket", "minecraft:tadpole_bucket");
    private static final List<String> RELEVANT_ENTITY_NBT_KEYS = List.of("NoAI", "Silent", "NoGravity", "Glowing", "Invulnerable", "Health", "Age", "Variant", "HuntingCooldown", "BucketVariantTag");
    private static final Set<String> BOOLEAN_BLOCK_STATE_PROPERTIES = Set.of("attached", "bottom", "conditional", "disarmed", "drag", "enabled", "extended", "eye", "falling", "hanging", "has_bottle_0", "has_bottle_1", "has_bottle_2", "has_record", "has_book", "inverted", "in_wall", "lit", "locked", "occupied", "open", "persistent", "powered", "short", "signal_fire", "snowy", "triggered", "unstable", "waterlogged", "berries", "bloom", "shrieking", "can_summon", "up", "down", "north", "east", "south", "west", "slot_0_occupied", "slot_1_occupied", "slot_2_occupied", "slot_3_occupied", "slot_4_occupied", "slot_5_occupied", "cracked", "crafting");
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');

    public ItemStackComponentizationFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    private static void fixStack(StackData data, Dynamic<?> dynamic) {
        int hideFlags = data.getAndRemove("HideFlags").asInt(0);
        data.moveToComponent("Damage", "minecraft:damage", dynamic.createInt(0));
        data.moveToComponent("RepairCost", "minecraft:repair_cost", dynamic.createInt(0));
        data.moveToComponent("CustomModelData", "minecraft:custom_model_data");
        data.getAndRemove("BlockStateTag").result().ifPresent(blockStateTagDynamic -> data.setComponent("minecraft:block_state", ItemStackComponentizationFix.fixBlockStateTag(blockStateTagDynamic)));
        data.moveToComponent("EntityTag", "minecraft:entity_data");
        data.applyFixer("BlockEntityTag", false, blockEntityTagDynamic -> {
            String id = IdentifierNormalizingSchema.normalize(blockEntityTagDynamic.get("id").asString(data.itemId));
            Dynamic newBlockEntityTagDynamic = (blockEntityTagDynamic = ItemStackComponentizationFix.fixBlockEntityData(data, blockEntityTagDynamic, id)).remove("id");
            return newBlockEntityTagDynamic.equals((Object)blockEntityTagDynamic.emptyMap()) ? newBlockEntityTagDynamic : blockEntityTagDynamic;
        });
        data.moveToComponent("BlockEntityTag", "minecraft:block_entity_data");
        if (data.getAndRemove("Unbreakable").asBoolean(false)) {
            Dynamic unbreakableComponent = dynamic.emptyMap();
            if ((hideFlags & 4) != 0) {
                unbreakableComponent = unbreakableComponent.set("show_in_tooltip", dynamic.createBoolean(false));
            }
            data.setComponent("minecraft:unbreakable", unbreakableComponent);
        }
        ItemStackComponentizationFix.fixEnchantments(data, dynamic, "Enchantments", "minecraft:enchantments", (hideFlags & 1) != 0);
        if (data.itemEquals("minecraft:enchanted_book")) {
            ItemStackComponentizationFix.fixEnchantments(data, dynamic, "StoredEnchantments", "minecraft:stored_enchantments", (hideFlags & 0x20) != 0);
        }
        data.applyFixer("display", false, displayDynamic -> ItemStackComponentizationFix.fixDisplay(data, displayDynamic, hideFlags));
        ItemStackComponentizationFix.fixAdventureModePredicates(data, dynamic, hideFlags);
        ItemStackComponentizationFix.fixAttributeModifiers(data, dynamic, hideFlags);
        Optional trimOpt = data.getAndRemove("Trim").result();
        if (trimOpt.isPresent()) {
            Dynamic trimComponentDynamic = (Dynamic)trimOpt.get();
            if ((hideFlags & 0x80) != 0) {
                trimComponentDynamic = trimComponentDynamic.set("show_in_tooltip", trimComponentDynamic.createBoolean(false));
            }
            data.setComponent("minecraft:trim", trimComponentDynamic);
        }
        if ((hideFlags & 0x20) != 0) {
            data.setComponent("minecraft:hide_additional_tooltip", dynamic.emptyMap());
        }
        if (data.itemEquals("minecraft:crossbow")) {
            data.getAndRemove("Charged");
            data.moveToComponent("ChargedProjectiles", "minecraft:charged_projectiles", dynamic.createList(Stream.empty()));
        }
        if (data.itemEquals("minecraft:bundle")) {
            data.moveToComponent("Items", "minecraft:bundle_contents", dynamic.createList(Stream.empty()));
        }
        if (data.itemEquals("minecraft:filled_map")) {
            data.moveToComponent("map", "minecraft:map_id");
            Map<Dynamic, Dynamic> map = data.getAndRemove("Decorations").asStream().map(ItemStackComponentizationFix::fixMapDecorations).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (dynamicx, dynamic2) -> dynamicx));
            if (!map.isEmpty()) {
                data.setComponent("minecraft:map_decorations", dynamic.createMap(map));
            }
        }
        if (data.itemMatches(POTION_ITEM_IDS)) {
            ItemStackComponentizationFix.fixPotionContents(data, dynamic);
        }
        if (data.itemEquals("minecraft:writable_book")) {
            ItemStackComponentizationFix.fixWritableBookContent(data, dynamic);
        }
        if (data.itemEquals("minecraft:written_book")) {
            ItemStackComponentizationFix.fixWrittenBookContent(data, dynamic);
        }
        if (data.itemEquals("minecraft:suspicious_stew")) {
            data.moveToComponent("effects", "minecraft:suspicious_stew_effects");
        }
        if (data.itemEquals("minecraft:debug_stick")) {
            data.moveToComponent("DebugProperty", "minecraft:debug_stick_state");
        }
        if (data.itemMatches(ENTITY_BUCKET_ITEM_IDS)) {
            ItemStackComponentizationFix.fixBucketEntityData(data, dynamic);
        }
        if (data.itemEquals("minecraft:goat_horn")) {
            data.moveToComponent("instrument", "minecraft:instrument");
        }
        if (data.itemEquals("minecraft:knowledge_book")) {
            data.moveToComponent("Recipes", "minecraft:recipes");
        }
        if (data.itemEquals("minecraft:compass")) {
            ItemStackComponentizationFix.fixLodestoneTarget(data, dynamic);
        }
        if (data.itemEquals("minecraft:firework_rocket")) {
            ItemStackComponentizationFix.fixFireworks(data);
        }
        if (data.itemEquals("minecraft:firework_star")) {
            ItemStackComponentizationFix.fixExplosion(data);
        }
        if (data.itemEquals("minecraft:player_head")) {
            data.getAndRemove("SkullOwner").result().ifPresent(skullOwnerDynamic -> data.setComponent("minecraft:profile", ItemStackComponentizationFix.createProfileDynamic(skullOwnerDynamic)));
        }
    }

    private static Dynamic<?> fixBlockStateTag(Dynamic<?> dynamic) {
        return (Dynamic)DataFixUtils.orElse(dynamic.asMapOpt().result().map(stream -> stream.collect(Collectors.toMap(Pair::getFirst, pair -> {
            Optional optional;
            String string = ((Dynamic)pair.getFirst()).asString("");
            Dynamic dynamicx = (Dynamic)pair.getSecond();
            if (BOOLEAN_BLOCK_STATE_PROPERTIES.contains(string) && (optional = dynamicx.asBoolean().result()).isPresent()) {
                return dynamicx.createString(String.valueOf(optional.get()));
            }
            optional = dynamicx.asNumber().result();
            return optional.isPresent() ? dynamicx.createString(((Number)optional.get()).toString()) : dynamicx;
        }))).map(arg_0 -> dynamic.createMap(arg_0)), dynamic);
    }

    private static <T> Dynamic<T> fixBlockEntityData(StackData data, Dynamic<T> dynamic, String blockEntityId) {
        Dynamic dynamic2;
        data.setComponent("minecraft:lock", dynamic.get("Lock"));
        dynamic = dynamic.remove("Lock");
        Optional optional = dynamic.get("LootTable").result();
        if (optional.isPresent()) {
            Dynamic dynamic22 = dynamic.emptyMap().set("loot_table", (Dynamic)optional.get());
            long l = dynamic.get("LootTableSeed").asLong(0L);
            if (l != 0L) {
                dynamic22 = dynamic22.set("seed", dynamic.createLong(l));
            }
            data.setComponent("minecraft:container_loot", dynamic22);
            dynamic = dynamic.remove("LootTable").remove("LootTableSeed");
        }
        String string = blockEntityId;
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"minecraft:skull", "minecraft:decorated_pot", String.class, "minecraft:shulker_box", "minecraft:chest", "minecraft:trapped_chest", "minecraft:furnace", "minecraft:ender_chest", "minecraft:dispenser", "minecraft:dropper", "minecraft:brewing_stand", "minecraft:hopper", "minecraft:barrel", "minecraft:smoker", "minecraft:blast_furnace", "minecraft:campfire", "minecraft:chiseled_bookshelf", "minecraft:crafter", "minecraft:beehive"}, (Object)string2, n)) {
                case 0: {
                    data.setComponent("minecraft:note_block_sound", dynamic.get("note_block_sound"));
                    dynamic2 = dynamic.remove("note_block_sound");
                    break block7;
                }
                case 1: {
                    data.setComponent("minecraft:pot_decorations", dynamic.get("sherds"));
                    Optional optional2 = dynamic.get("item").result();
                    if (optional2.isPresent()) {
                        data.setComponent("minecraft:container", dynamic.createList(Stream.of(dynamic.emptyMap().set("slot", dynamic.createInt(0)).set("item", (Dynamic)optional2.get()))));
                    }
                    dynamic2 = dynamic.remove("sherds").remove("item");
                    break block7;
                }
                case 2: {
                    String s = string2;
                    if (!s.startsWith("minecraft:") || !s.endsWith("banner")) {
                        n = 3;
                        continue block7;
                    }
                    data.setComponent("minecraft:banner_patterns", dynamic.get("patterns"));
                    Optional baseOpt = dynamic.get("Base").asNumber().result();
                    if (baseOpt.isPresent()) {
                        data.setComponent("minecraft:base_color", dynamic.createString(BannerPatternFormatFix.getColourFromInt(((Number)baseOpt.get()).intValue())));
                    }
                    dynamic2 = dynamic.remove("patterns").remove("Base");
                    break block7;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    List items = dynamic.get("Items").asList(itemsDynamic -> itemsDynamic.emptyMap().set("slot", itemsDynamic.createInt(itemsDynamic.get("Slot").asByte((byte)0) & 0xFF)).set("item", itemsDynamic.remove("Slot")));
                    if (!items.isEmpty()) {
                        data.setComponent("minecraft:container", dynamic.createList(items.stream()));
                    }
                    dynamic2 = dynamic.remove("Items");
                    break block7;
                }
                case 18: {
                    data.setComponent("minecraft:bees", dynamic.get("bees"));
                    dynamic2 = dynamic.remove("bees");
                    break block7;
                }
                default: {
                    dynamic2 = dynamic;
                    break block7;
                }
            }
            break;
        }
        return dynamic2;
    }

    private static void fixEnchantments(StackData data, Dynamic<?> dynamic, String nbtKey, String componentId, boolean hideInTooltip) {
        OptionalDynamic<?> enchantmentsListDynamic = data.getAndRemove(nbtKey);
        List enchantmentsApplied = enchantmentsListDynamic.asList(Function.identity()).stream().flatMap(enchantmentsDynamic -> ItemStackComponentizationFix.getEnchantmentAndLevelPair(enchantmentsDynamic).stream()).toList();
        if (!enchantmentsApplied.isEmpty() || hideInTooltip) {
            Dynamic componentDynamic = dynamic.emptyMap();
            Dynamic levelsDynamic = dynamic.emptyMap();
            for (Pair pair : enchantmentsApplied) {
                levelsDynamic = levelsDynamic.set((String)pair.getFirst(), dynamic.createInt(((Integer)pair.getSecond()).intValue()));
            }
            componentDynamic = componentDynamic.set("levels", levelsDynamic);
            if (hideInTooltip) {
                componentDynamic = componentDynamic.set("show_in_tooltip", dynamic.createBoolean(false));
            }
            data.setComponent(componentId, componentDynamic);
        }
        if (enchantmentsListDynamic.result().isPresent() && enchantmentsApplied.isEmpty()) {
            data.setComponent("minecraft:enchantment_glint_override", dynamic.createBoolean(true));
        }
    }

    private static Optional<Pair<String, Integer>> getEnchantmentAndLevelPair(Dynamic<?> dynamic) {
        return dynamic.get("id").asString().apply2stable((enchantmentId, level) -> Pair.of((Object)enchantmentId, (Object)Math.clamp((long)level.intValue(), 0, 255)), dynamic.get("lvl").asNumber()).result();
    }

    private static Dynamic<?> fixDisplay(StackData data, Dynamic<?> dynamic, int hideFlags) {
        Optional localizedNameOpt;
        boolean hideDyeColour;
        data.setComponent("minecraft:custom_name", dynamic.get("Name"));
        data.setComponent("minecraft:lore", dynamic.get("Lore"));
        Optional<Integer> dyeColourOptional = dynamic.get("color").asNumber().result().map(Number::intValue);
        boolean bl = hideDyeColour = (hideFlags & 0x40) != 0;
        if (dyeColourOptional.isPresent() || hideDyeColour) {
            Dynamic dyeColourComponentDynamic = dynamic.emptyMap().set("rgb", dynamic.createInt(dyeColourOptional.orElse(10511680).intValue()));
            if (hideDyeColour) {
                dyeColourComponentDynamic = dyeColourComponentDynamic.set("show_in_tooltip", dynamic.createBoolean(false));
            }
            data.setComponent("minecraft:dyed_color", dyeColourComponentDynamic);
        }
        if ((localizedNameOpt = dynamic.get("LocName").asString().result()).isPresent()) {
            data.setComponent("minecraft:item_name", TextFixes.translate(dynamic.getOps(), (String)localizedNameOpt.get()));
        }
        if (data.itemEquals("minecraft:filled_map")) {
            data.setComponent("minecraft:map_color", dynamic.get("MapColor"));
            dynamic = dynamic.remove("MapColor");
        }
        return dynamic.remove("Name").remove("Lore").remove("color").remove("LocName");
    }

    private static void fixAdventureModePredicates(StackData data, Dynamic<?> dynamic, int hideFlags) {
        ItemStackComponentizationFix.fixBlockPredicateList(data, dynamic, "CanDestroy", "minecraft:can_break", (hideFlags & 8) != 0);
        ItemStackComponentizationFix.fixBlockPredicateList(data, dynamic, "CanPlaceOn", "minecraft:can_place_on", (hideFlags & 0x10) != 0);
    }

    private static void fixBlockPredicateList(StackData data, Dynamic<?> dynamic, String nbtKey, String componentId, boolean hideInTooltip) {
        Optional optional = data.getAndRemove(nbtKey).result();
        if (!optional.isEmpty()) {
            Dynamic componentDynamic = dynamic.emptyMap().set("predicates", dynamic.createList(((Dynamic)optional.get()).asStream().map(predicatesDynamic -> (Dynamic)DataFixUtils.orElse((Optional)predicatesDynamic.asString().map(string -> ItemStackComponentizationFix.createBlockPredicateListDynamic(predicatesDynamic, string)).result(), (Object)predicatesDynamic))));
            if (hideInTooltip) {
                componentDynamic = componentDynamic.set("show_in_tooltip", dynamic.createBoolean(false));
            }
            data.setComponent(componentId, componentDynamic);
        }
    }

    private static Dynamic<?> createBlockPredicateListDynamic(Dynamic<?> dynamic, String listAsString) {
        int i = listAsString.indexOf(91);
        int j = listAsString.indexOf(123);
        int k = listAsString.length();
        if (i != -1) {
            k = i;
        }
        if (j != -1) {
            k = Math.min(k, j);
        }
        String string = listAsString.substring(0, k);
        Dynamic dynamic2 = dynamic.emptyMap().set("blocks", dynamic.createString(string.trim()));
        int l = listAsString.indexOf(93);
        if (i != -1 && l != -1) {
            Dynamic dynamic3 = dynamic.emptyMap();
            for (String string2 : COMMA_SPLITTER.split((CharSequence)listAsString.substring(i + 1, l))) {
                int m = string2.indexOf(61);
                if (m == -1) continue;
                String string3 = string2.substring(0, m).trim();
                String string4 = string2.substring(m + 1).trim();
                dynamic3 = dynamic3.set(string3, dynamic.createString(string4));
            }
            dynamic2 = dynamic2.set("state", dynamic3);
        }
        int n = listAsString.indexOf(125);
        if (j != -1 && n != -1) {
            dynamic2 = dynamic2.set("nbt", dynamic.createString(listAsString.substring(j, n + 1)));
        }
        return dynamic2;
    }

    private static void fixAttributeModifiers(StackData data, Dynamic<?> dynamic, int hideFlags) {
        OptionalDynamic<?> oldAttributeModifiers = data.getAndRemove("AttributeModifiers");
        if (!oldAttributeModifiers.result().isEmpty()) {
            boolean hideModifiersFromTooltip = (hideFlags & 2) != 0;
            List modifiers = oldAttributeModifiers.asList(ItemStackComponentizationFix::fixAttributeModifier);
            Dynamic attributeModifiersComponentDynamic = dynamic.emptyMap().set("modifiers", dynamic.createList(modifiers.stream()));
            if (hideModifiersFromTooltip) {
                attributeModifiersComponentDynamic = attributeModifiersComponentDynamic.set("show_in_tooltip", dynamic.createBoolean(false));
            }
            data.setComponent("minecraft:attribute_modifiers", attributeModifiersComponentDynamic);
        }
    }

    private static Dynamic<?> fixAttributeModifier(Dynamic<?> dynamic) {
        Dynamic modifier = dynamic.emptyMap().set("name", dynamic.createString("")).set("amount", dynamic.createDouble(0.0)).set("operation", dynamic.createString("add_value"));
        modifier = Dynamic.copyField(dynamic, (String)"AttributeName", (Dynamic)modifier, (String)"type");
        modifier = Dynamic.copyField(dynamic, (String)"Slot", (Dynamic)modifier, (String)"slot");
        modifier = Dynamic.copyField(dynamic, (String)"UUID", (Dynamic)modifier, (String)"uuid");
        modifier = Dynamic.copyField(dynamic, (String)"Name", (Dynamic)modifier, (String)"name");
        modifier = Dynamic.copyField(dynamic, (String)"Amount", (Dynamic)modifier, (String)"amount");
        return Dynamic.copyAndFixField(dynamic, (String)"Operation", (Dynamic)modifier, (String)"operation", operationDynamic -> operationDynamic.createString(switch (operationDynamic.asInt(0)) {
            case 1 -> "add_multiplied_base";
            case 2 -> "add_multiplied_total";
            default -> "add_value";
        }));
    }

    private static Pair<Dynamic<?>, Dynamic<?>> fixMapDecorations(Dynamic<?> dynamic) {
        Dynamic idDynamic = (Dynamic)DataFixUtils.orElseGet((Optional)dynamic.get("id").result(), () -> dynamic.createString(""));
        Dynamic dynamic3 = dynamic.emptyMap().set("type", dynamic.createString(ItemStackComponentizationFix.getMapDecorationName(dynamic.get("type").asInt(0)))).set("x", dynamic.createDouble(dynamic.get("x").asDouble(0.0))).set("z", dynamic.createDouble(dynamic.get("z").asDouble(0.0))).set("rotation", dynamic.createFloat((float)dynamic.get("rot").asDouble(0.0)));
        return Pair.of((Object)idDynamic, (Object)dynamic3);
    }

    private static String getMapDecorationName(int index) {
        return switch (index) {
            case 1 -> "frame";
            case 2 -> "red_marker";
            case 3 -> "blue_marker";
            case 4 -> "target_x";
            case 5 -> "target_point";
            case 6 -> "player_off_map";
            case 7 -> "player_off_limits";
            case 8 -> "mansion";
            case 9 -> "monument";
            case 10 -> "banner_white";
            case 11 -> "banner_orange";
            case 12 -> "banner_magenta";
            case 13 -> "banner_light_blue";
            case 14 -> "banner_yellow";
            case 15 -> "banner_lime";
            case 16 -> "banner_pink";
            case 17 -> "banner_gray";
            case 18 -> "banner_light_gray";
            case 19 -> "banner_cyan";
            case 20 -> "banner_purple";
            case 21 -> "banner_blue";
            case 22 -> "banner_brown";
            case 23 -> "banner_green";
            case 24 -> "banner_red";
            case 25 -> "banner_black";
            case 26 -> "red_x";
            case 27 -> "village_desert";
            case 28 -> "village_plains";
            case 29 -> "village_savanna";
            case 30 -> "village_snowy";
            case 31 -> "village_taiga";
            case 32 -> "jungle_temple";
            case 33 -> "swamp_hut";
            default -> "player";
        };
    }

    private static void fixPotionContents(StackData data, Dynamic<?> dynamic) {
        Dynamic<?> potionContentsComponent = dynamic.emptyMap();
        Optional<String> potion = data.getAndRemove("Potion").asString().result().filter(potionId -> !potionId.equals("minecraft:empty"));
        if (potion.isPresent()) {
            potionContentsComponent = potionContentsComponent.set("potion", dynamic.createString(potion.get()));
        }
        potionContentsComponent = data.moveToComponent("CustomPotionColor", potionContentsComponent, "custom_color");
        if (!(potionContentsComponent = data.moveToComponent("custom_potion_effects", potionContentsComponent, "custom_effects")).equals((Object)dynamic.emptyMap())) {
            data.setComponent("minecraft:potion_contents", potionContentsComponent);
        }
    }

    private static void fixWritableBookContent(StackData data, Dynamic<?> dynamic) {
        Dynamic<?> writableBookContentComponent = ItemStackComponentizationFix.fixBookPages(data, dynamic);
        if (writableBookContentComponent != null) {
            data.setComponent("minecraft:writable_book_content", dynamic.emptyMap().set("pages", writableBookContentComponent));
        }
    }

    private static void fixWrittenBookContent(StackData data, Dynamic<?> dynamic) {
        Dynamic<?> pages = ItemStackComponentizationFix.fixBookPages(data, dynamic);
        String title = data.getAndRemove("title").asString("");
        Optional filteredTitleOpt = data.getAndRemove("filtered_title").asString().result();
        Dynamic writtenBookContentComponent = dynamic.emptyMap();
        writtenBookContentComponent = writtenBookContentComponent.set("title", ItemStackComponentizationFix.createFilterableTextDynamic(dynamic, title, filteredTitleOpt));
        writtenBookContentComponent = data.moveToComponent("author", writtenBookContentComponent, "author");
        writtenBookContentComponent = data.moveToComponent("resolved", writtenBookContentComponent, "resolved");
        writtenBookContentComponent = data.moveToComponent("generation", writtenBookContentComponent, "generation");
        if (pages != null) {
            writtenBookContentComponent = writtenBookContentComponent.set("pages", pages);
        }
        data.setComponent("minecraft:written_book_content", writtenBookContentComponent);
    }

    @Nullable
    private static Dynamic<?> fixBookPages(StackData data, Dynamic<?> dynamic) {
        List pages = data.getAndRemove("pages").asList(pagesDynamic -> pagesDynamic.asString(""));
        Map filteredPages = data.getAndRemove("filtered_pages").asMap(filteredPagesKeyDynamic -> filteredPagesKeyDynamic.asString("0"), filteredPagesValueDynamic -> filteredPagesValueDynamic.asString(""));
        if (pages.isEmpty()) {
            return null;
        }
        ArrayList list2 = new ArrayList(pages.size());
        for (int i = 0; i < pages.size(); ++i) {
            String string = (String)pages.get(i);
            String string2 = (String)filteredPages.get(String.valueOf(i));
            list2.add(ItemStackComponentizationFix.createFilterableTextDynamic(dynamic, string, Optional.ofNullable(string2)));
        }
        return dynamic.createList(list2.stream());
    }

    private static Dynamic<?> createFilterableTextDynamic(Dynamic<?> dynamic, String unfiltered, Optional<String> filtered) {
        Dynamic dynamic2 = dynamic.emptyMap().set("raw", dynamic.createString(unfiltered));
        if (filtered.isPresent()) {
            dynamic2 = dynamic2.set("filtered", dynamic.createString(filtered.get()));
        }
        return dynamic2;
    }

    private static void fixBucketEntityData(StackData data, Dynamic<?> dynamic) {
        Dynamic<?> bucketEntityDataComponentDynamic = dynamic.emptyMap();
        for (String string : RELEVANT_ENTITY_NBT_KEYS) {
            bucketEntityDataComponentDynamic = data.moveToComponent(string, bucketEntityDataComponentDynamic, string);
        }
        if (!bucketEntityDataComponentDynamic.equals((Object)dynamic.emptyMap())) {
            data.setComponent("minecraft:bucket_entity_data", bucketEntityDataComponentDynamic);
        }
    }

    private static void fixLodestoneTarget(StackData data, Dynamic<?> dynamic) {
        Optional lodestonePosOpt = data.getAndRemove("LodestonePos").result();
        Optional lodestoneDimensionOpt = data.getAndRemove("LodestoneDimension").result();
        if (!lodestonePosOpt.isEmpty() || !lodestoneDimensionOpt.isEmpty()) {
            boolean lodestoneTracked = data.getAndRemove("LodestoneTracked").asBoolean(true);
            Dynamic lodestoneTrackerComponentDynamic = dynamic.emptyMap();
            if (lodestonePosOpt.isPresent() && lodestoneDimensionOpt.isPresent()) {
                lodestoneTrackerComponentDynamic = lodestoneTrackerComponentDynamic.set("target", dynamic.emptyMap().set("pos", (Dynamic)lodestonePosOpt.get()).set("dimension", (Dynamic)lodestoneDimensionOpt.get()));
            }
            if (!lodestoneTracked) {
                lodestoneTrackerComponentDynamic = lodestoneTrackerComponentDynamic.set("tracked", dynamic.createBoolean(false));
            }
            data.setComponent("minecraft:lodestone_tracker", lodestoneTrackerComponentDynamic);
        }
    }

    private static void fixExplosion(StackData data) {
        data.applyFixer("Explosion", true, explosionDynamic -> {
            data.setComponent("minecraft:firework_explosion", ItemStackComponentizationFix.fixExplosion(explosionDynamic));
            return explosionDynamic.remove("Type").remove("Colors").remove("FadeColors").remove("Trail").remove("Flicker");
        });
    }

    private static void fixFireworks(StackData data) {
        data.applyFixer("Fireworks", true, fireworksDynamic -> {
            Stream<Dynamic> stream = fireworksDynamic.get("Explosions").asStream().map(ItemStackComponentizationFix::fixExplosion);
            int flightDuration = fireworksDynamic.get("Flight").asInt(0);
            data.setComponent("minecraft:fireworks", fireworksDynamic.emptyMap().set("explosions", fireworksDynamic.createList(stream)).set("flight_duration", fireworksDynamic.createByte((byte)flightDuration)));
            return fireworksDynamic.remove("Explosions").remove("Flight");
        });
    }

    private static Dynamic<?> fixExplosion(Dynamic<?> dynamic) {
        dynamic = dynamic.set("shape", dynamic.createString(switch (dynamic.get("Type").asInt(0)) {
            case 1 -> "large_ball";
            case 2 -> "star";
            case 3 -> "creeper";
            case 4 -> "burst";
            default -> "small_ball";
        })).remove("Type");
        dynamic = dynamic.renameField("Colors", "colors");
        dynamic = dynamic.renameField("FadeColors", "fade_colors");
        dynamic = dynamic.renameField("Trail", "has_trail");
        return dynamic.renameField("Flicker", "has_twinkle");
    }

    public static Dynamic<?> createProfileDynamic(Dynamic<?> dynamic) {
        Optional optional = dynamic.asString().result();
        if (optional.isPresent()) {
            return ItemStackComponentizationFix.isValidUsername((String)optional.get()) ? dynamic.emptyMap().set("name", dynamic.createString((String)optional.get())) : dynamic.emptyMap();
        }
        String name = dynamic.get("Name").asString("");
        Optional optional2 = dynamic.get("Id").result();
        Dynamic<?> propertiesDynamic = ItemStackComponentizationFix.createPropertiesDynamic(dynamic.get("Properties"));
        Dynamic profileComponentDynamic = dynamic.emptyMap();
        if (ItemStackComponentizationFix.isValidUsername(name)) {
            profileComponentDynamic = profileComponentDynamic.set("name", dynamic.createString(name));
        }
        if (optional2.isPresent()) {
            profileComponentDynamic = profileComponentDynamic.set("id", (Dynamic)optional2.get());
        }
        if (propertiesDynamic != null) {
            profileComponentDynamic = profileComponentDynamic.set("properties", propertiesDynamic);
        }
        return profileComponentDynamic;
    }

    private static boolean isValidUsername(String username) {
        return username.length() > 16 ? false : username.chars().filter(c -> c <= 32 || c >= 127).findAny().isEmpty();
    }

    @Nullable
    private static Dynamic<?> createPropertiesDynamic(OptionalDynamic<?> propertiesDynamic) {
        Map map = propertiesDynamic.asMap(dynamic -> dynamic.asString(""), dynamic -> dynamic.asList(dynamicx -> {
            String string = dynamicx.get("Value").asString("");
            Optional optional = dynamicx.get("Signature").asString().result();
            return Pair.of((Object)string, (Object)optional);
        }));
        return map.isEmpty() ? null : propertiesDynamic.createList(map.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(pair -> {
            Dynamic propertyDynamic = propertiesDynamic.emptyMap().set("name", propertiesDynamic.createString((String)entry.getKey())).set("value", propertiesDynamic.createString((String)pair.getFirst()));
            Optional optional = (Optional)pair.getSecond();
            return optional.isPresent() ? propertyDynamic.set("signature", propertiesDynamic.createString((String)optional.get())) : propertyDynamic;
        })));
    }

    protected TypeRewriteRule makeRule() {
        return this.writeFixAndRead("ItemStack componentization", this.getInputSchema().getType(TypeReferences.LEGACY_ITEM_STACK), this.getOutputSchema().getType(TypeReferences.LEGACY_ITEM_STACK), itemStackDynamic -> {
            Optional<Dynamic> optional = StackData.fromDynamic(itemStackDynamic).map(data -> {
                ItemStackComponentizationFix.fixStack(data, data.nbt);
                return data.finalizeFix();
            });
            return (Dynamic)DataFixUtils.orElse(optional, (Object)itemStackDynamic);
        });
    }

    private static class StackData {
        private final String itemId;
        private final int count;
        private Dynamic<?> components;
        private Dynamic<?> nbt;
        private final Dynamic<?> leftoverNbt;

        StackData(String itemId, int count, Dynamic<?> dynamic) {
            this.itemId = IdentifierNormalizingSchema.normalize(itemId);
            this.count = count;
            this.components = dynamic.emptyMap();
            this.nbt = dynamic.get("tag").orElseEmptyMap();
            this.leftoverNbt = dynamic.remove("tag");
        }

        static Optional<StackData> fromDynamic(Dynamic<?> dynamic) {
            return dynamic.get("id").asString().apply2stable((itemId, count) -> new StackData((String)itemId, count.intValue(), (Dynamic<?>)dynamic.remove("id").remove("Count")), dynamic.get("Count").asNumber()).result();
        }

        OptionalDynamic<?> getAndRemove(String key) {
            OptionalDynamic element = this.nbt.get(key);
            this.nbt = this.nbt.remove(key);
            return element;
        }

        void setComponent(String key, Dynamic<?> value) {
            this.components = this.components.set(key, value);
        }

        void setComponent(String key, OptionalDynamic<?> optionalValue) {
            optionalValue.result().ifPresent(value -> {
                this.components = this.components.set(key, value);
            });
        }

        void moveToComponent(String nbtKey, String componentId, Dynamic<?> defaultValue) {
            Optional optional = this.getAndRemove(nbtKey).result();
            if (optional.isPresent() && !((Dynamic)optional.get()).equals(defaultValue)) {
                this.setComponent(componentId, (Dynamic)optional.get());
            }
        }

        void moveToComponent(String nbtKey, String componentId) {
            this.getAndRemove(nbtKey).result().ifPresent(nbt -> this.setComponent(componentId, (Dynamic<?>)nbt));
        }

        void applyFixer(String nbtKey, boolean removeIfEmpty, UnaryOperator<Dynamic<?>> fixer) {
            OptionalDynamic optionalDynamic = this.nbt.get(nbtKey);
            if (!removeIfEmpty || !optionalDynamic.result().isEmpty()) {
                Dynamic dynamic = optionalDynamic.orElseEmptyMap();
                this.nbt = (dynamic = (Dynamic)fixer.apply(dynamic)).equals((Object)dynamic.emptyMap()) ? this.nbt.remove(nbtKey) : this.nbt.set(nbtKey, dynamic);
            }
        }

        Dynamic<?> moveToComponent(String nbtKey, Dynamic<?> components, String componentId) {
            Optional optional = this.getAndRemove(nbtKey).result();
            return optional.isPresent() ? components.set(componentId, (Dynamic)optional.get()) : components;
        }

        Dynamic<?> finalizeFix() {
            Dynamic stack = this.nbt.emptyMap().set("id", this.nbt.createString(this.itemId)).set("count", this.nbt.createInt(this.count));
            if (!this.nbt.equals((Object)this.nbt.emptyMap())) {
                this.components = this.components.set("minecraft:custom_data", this.nbt);
            }
            if (!this.components.equals((Object)this.nbt.emptyMap())) {
                stack = stack.set("components", this.components);
            }
            return StackData.mergeLeftoverNbt(stack, this.leftoverNbt);
        }

        static <T> Dynamic<T> mergeLeftoverNbt(Dynamic<T> data, Dynamic<?> leftoverNbt) {
            DynamicOps ops = data.getOps();
            return ops.getMap(data.getValue()).flatMap(mapLike -> ops.mergeToMap(leftoverNbt.convert(ops).getValue(), mapLike)).map(object -> new Dynamic(ops, object)).result().orElse(data);
        }

        boolean itemEquals(String itemId) {
            return this.itemId.equals(itemId);
        }

        boolean itemMatches(Set<String> itemIds) {
            return itemIds.contains(this.itemId);
        }

        boolean itemContains(String componentId) {
            return this.components.get(componentId).result().isPresent();
        }
    }
}

