/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.config.v2.impl.serializer;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.ConfigField;
import dev.isxander.yacl3.config.v2.api.ConfigSerializer;
import dev.isxander.yacl3.config.v2.api.FieldAccess;
import dev.isxander.yacl3.config.v2.api.SerialField;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import dev.isxander.yacl3.gui.utils.ItemRegistryHelper;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.awt.Color;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.quiltmc.parsers.json.JsonReader;
import org.quiltmc.parsers.json.JsonWriter;
import org.quiltmc.parsers.json.gson.GsonReader;
import org.quiltmc.parsers.json.gson.GsonWriter;

public class GsonConfigSerializer<T>
extends ConfigSerializer<T> {
    private final Gson gson;
    private final Path path;
    private final boolean json5;

    private GsonConfigSerializer(ConfigClassHandler<T> config, Path path, Gson gson, boolean json5) {
        super(config);
        this.gson = gson;
        this.path = path;
        this.json5 = json5;
    }

    @Override
    public void save() {
        YACLConstants.LOGGER.info("Serializing {} to '{}'", this.config.configClass(), (Object)this.path);
        try {
            StringWriter stringWriter = new StringWriter();
            try {
                JsonWriter jsonWriter = this.json5 ? JsonWriter.json5((Writer)stringWriter) : JsonWriter.json((Writer)stringWriter);
                GsonWriter gsonWriter = new GsonWriter(jsonWriter);
                jsonWriter.beginObject();
                for (ConfigField<?> field : this.config.fields()) {
                    JsonElement element;
                    SerialField serial = field.serial().orElse(null);
                    if (serial == null) continue;
                    if (!this.json5 && serial.comment().isPresent() && YACLPlatform.isDevelopmentEnv()) {
                        YACLConstants.LOGGER.warn("Found comment in config field '{}', but json5 is not enabled. Enable it with `.setJson5(true)` on the `GsonConfigSerializerBuilder`. Comments will not be serialized. This warning is only visible in development environments.", (Object)serial.serialName());
                    }
                    jsonWriter.comment((String)serial.comment().orElse(null));
                    jsonWriter.name(serial.serialName());
                    try {
                        element = this.gson.toJsonTree(field.access().get(), field.access().type());
                    }
                    catch (Exception e) {
                        YACLConstants.LOGGER.error("Failed to serialize config field '{}'. Serializing as null.", (Object)serial.serialName(), (Object)e);
                        jsonWriter.nullValue();
                        continue;
                    }
                    try {
                        this.gson.toJson(element, (com.google.gson.stream.JsonWriter)gsonWriter);
                    }
                    catch (Exception e) {
                        YACLConstants.LOGGER.error("Failed to serialize config field '{}'. Due to the error state this JSON writer cannot continue safely and the save will be abandoned.", (Object)serial.serialName(), (Object)e);
                        stringWriter.close();
                        return;
                    }
                }
                jsonWriter.endObject();
                jsonWriter.flush();
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                Files.writeString(this.path, (CharSequence)stringWriter.toString(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            }
            finally {
                try {
                    stringWriter.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (IOException e) {
            YACLConstants.LOGGER.error("Failed to serialize config class '{}'.", (Object)this.config.configClass().getSimpleName(), (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConfigSerializer.LoadResult loadSafely(Map<ConfigField<?>, FieldAccess<?>> bufferAccessMap) {
        ConfigSerializer.LoadResult loadResult;
        if (!Files.exists(this.path, new LinkOption[0])) {
            YACLConstants.LOGGER.info("Config file '{}' does not exist. Creating it with default values.", (Object)this.path);
            this.save();
            return ConfigSerializer.LoadResult.NO_CHANGE;
        }
        YACLConstants.LOGGER.info("Deserializing {} from '{}'", (Object)this.config.configClass().getSimpleName(), (Object)this.path);
        Map fieldMap = Arrays.stream(this.config.fields()).filter(field -> field.serial().isPresent()).collect(Collectors.toMap(f -> f.serial().orElseThrow().serialName(), Function.identity()));
        Set<String> missingFields = fieldMap.keySet();
        boolean dirty = false;
        try {
            JsonReader jsonReader = this.json5 ? JsonReader.json5((Path)this.path) : JsonReader.json((Path)this.path);
            try {
                GsonReader gsonReader = new GsonReader(jsonReader);
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    JsonElement element;
                    String name = jsonReader.nextName();
                    ConfigField field2 = (ConfigField)fieldMap.get(name);
                    missingFields.remove(name);
                    if (field2 == null) {
                        YACLConstants.LOGGER.warn("Found unknown config field '{}'.", (Object)name);
                        jsonReader.skipValue();
                        continue;
                    }
                    FieldAccess<?> bufferAccess = bufferAccessMap.get(field2);
                    SerialField serial = field2.serial().orElse(null);
                    if (serial == null) continue;
                    try {
                        element = (JsonElement)this.gson.fromJson((com.google.gson.stream.JsonReader)gsonReader, JsonElement.class);
                    }
                    catch (Exception e) {
                        YACLConstants.LOGGER.error("Failed to deserialize config field '{}'. Due to the error state this JSON reader cannot be re-used and loading will be aborted.", (Object)name, (Object)e);
                        ConfigSerializer.LoadResult loadResult2 = ConfigSerializer.LoadResult.FAILURE;
                        if (jsonReader == null) return loadResult2;
                        jsonReader.close();
                        return loadResult2;
                    }
                    if (element.isJsonNull() && !serial.nullable()) {
                        YACLConstants.LOGGER.warn("Found null value in non-nullable config field '{}'. Leaving field as default and marking as dirty.", (Object)name);
                        dirty = true;
                        continue;
                    }
                    try {
                        bufferAccess.set(this.gson.fromJson(element, bufferAccess.type()));
                    }
                    catch (Exception e) {
                        YACLConstants.LOGGER.error("Failed to deserialize config field '{}'. Leaving as default.", (Object)name, (Object)e);
                    }
                }
                jsonReader.endObject();
            }
            finally {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable) {
                        Throwable gsonReader;
                        gsonReader.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            YACLConstants.LOGGER.error("Failed to deserialize config class.", (Throwable)e);
            return ConfigSerializer.LoadResult.FAILURE;
        }
        if (!missingFields.isEmpty()) {
            for (String missingField : missingFields) {
                if (!((ConfigField)fieldMap.get(missingField)).serial().orElseThrow().required()) continue;
                dirty = true;
                YACLConstants.LOGGER.warn("Missing required config field '{}''. Re-saving as default.", (Object)missingField);
            }
        }
        if (dirty) {
            loadResult = ConfigSerializer.LoadResult.DIRTY;
            return loadResult;
        }
        loadResult = ConfigSerializer.LoadResult.SUCCESS;
        return loadResult;
    }

    @Override
    @Deprecated
    public void load() {
        YACLConstants.LOGGER.warn("Calling ConfigSerializer#load() directly is deprecated. Please use ConfigClassHandler#load() instead.");
        this.config.load();
    }

    @ApiStatus.Internal
    public static class Builder<T>
    implements GsonConfigSerializerBuilder<T> {
        private final ConfigClassHandler<T> config;
        private Path path;
        private boolean json5;
        private UnaryOperator<GsonBuilder> gsonBuilder = builder2 -> builder2.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).serializeNulls().registerTypeHierarchyAdapter(class_2561.class, (Object)new class_2561.class_8822((class_7225.class_7874)class_5455.field_40585)).registerTypeHierarchyAdapter(class_2583.class, (Object)new StyleTypeAdapter()).registerTypeHierarchyAdapter(Color.class, (Object)new ColorTypeAdapter()).registerTypeHierarchyAdapter(class_1792.class, (Object)new ItemTypeAdapter()).setPrettyPrinting();

        public Builder(ConfigClassHandler<T> config) {
            this.config = config;
        }

        @Override
        public Builder<T> setPath(Path path) {
            this.path = path;
            return this;
        }

        @Override
        public Builder<T> overrideGsonBuilder(GsonBuilder gsonBuilder) {
            this.gsonBuilder = builder2 -> gsonBuilder;
            return this;
        }

        @Override
        public Builder<T> overrideGsonBuilder(Gson gson) {
            return this.overrideGsonBuilder(gson.newBuilder());
        }

        @Override
        public Builder<T> appendGsonBuilder(UnaryOperator<GsonBuilder> gsonBuilder) {
            UnaryOperator<GsonBuilder> prev = this.gsonBuilder;
            this.gsonBuilder = builder2 -> (GsonBuilder)gsonBuilder.apply((GsonBuilder)prev.apply((GsonBuilder)builder2));
            return this;
        }

        @Override
        public Builder<T> setJson5(boolean json5) {
            this.json5 = json5;
            return this;
        }

        @Override
        public GsonConfigSerializer<T> build() {
            return new GsonConfigSerializer<T>(this.config, this.path, ((GsonBuilder)this.gsonBuilder.apply(new GsonBuilder())).create(), this.json5);
        }
    }

    public static class ItemTypeAdapter
    implements JsonSerializer<class_1792>,
    JsonDeserializer<class_1792> {
        public class_1792 deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return ItemRegistryHelper.getItemFromName(jsonElement.getAsString());
        }

        public JsonElement serialize(class_1792 item, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(class_7923.field_41178.method_10221((Object)item).toString());
        }
    }

    public static class ColorTypeAdapter
    implements JsonSerializer<Color>,
    JsonDeserializer<Color> {
        public Color deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return new Color(jsonElement.getAsInt(), true);
        }

        public JsonElement serialize(Color color, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)color.getRGB());
        }
    }

    public static class StyleTypeAdapter
    implements JsonSerializer<class_2583>,
    JsonDeserializer<class_2583> {
        public class_2583 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return class_2583.class_2584.field_46613.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().orElse(class_2583.field_24360);
        }

        public JsonElement serialize(class_2583 src, Type typeOfSrc, JsonSerializationContext context) {
            return (JsonElement)class_2583.class_2584.field_46613.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)src).result().orElse(JsonNull.INSTANCE);
        }
    }
}

