/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.hmapi;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.azureaaron.hmapi.events.HypixelPacketEvents;
import net.azureaaron.hmapi.network.HypixelNetworking;
import net.azureaaron.hmapi.network.packet.s2c.HypixelS2CPacket;
import net.azureaaron.hmapi.network.packet.v1.s2c.LocationUpdateS2CPacket;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.slf4j.Logger;

public class HMApi
implements ClientModInitializer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean DEBUG_ENABLED = Boolean.parseBoolean(System.getProperty("hmapi.debug", "false")) || FabricLoader.getInstance().isDevelopmentEnvironment();
    private static boolean sendPacketsInChat;

    @Deprecated(forRemoval=true)
    public HMApi() {
    }

    public void onInitializeClient() {
        if (DEBUG_ENABLED) {
            ClientCommandRegistrationCallback.EVENT.register(HMApi::registerCommands);
            HypixelPacketEvents.PARTY_INFO.register(HMApi::logPacket);
            HypixelPacketEvents.PLAYER_INFO.register(HMApi::logPacket);
            HypixelPacketEvents.HELLO.register(HMApi::logPacket);
            HypixelPacketEvents.LOCATION_UPDATE.register(HMApi::logPacket);
        }
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"hmapi").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sendPacket").then(ClientCommandManager.literal((String)"partyInfo2").executes(context -> {
            HypixelNetworking.sendPartyInfoC2SPacket(2);
            return 1;
        }))).then(ClientCommandManager.literal((String)"playerInfo").executes(context -> {
            HypixelNetworking.sendPlayerInfoC2SPacket(1);
            return 1;
        }))).then(ClientCommandManager.literal((String)"register4LocationUpdates").executes(context -> {
            HypixelNetworking.registerToEvents((Object2IntMap<class_8710.class_9154<HypixelS2CPacket>>)((Object2IntMap)class_156.method_654((Object)new Object2IntOpenHashMap(), map -> map.put(LocationUpdateS2CPacket.ID, 1))));
            return 1;
        })))).then(ClientCommandManager.literal((String)"toggleSendPacketsInChat").executes(context -> {
            sendPacketsInChat = true;
            return 1;
        })));
    }

    private static void logPacket(HypixelS2CPacket packet) {
        class_746 player = class_310.method_1551().field_1724;
        LOGGER.info("[HM API] Received Packet: {}", (Object)packet);
        if (player != null && sendPacketsInChat) {
            player.method_7353(class_2561.method_30163((String)packet.toString()), false);
        }
    }
}

