/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.hmapi.network;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.azureaaron.hmapi.network.HypixelNetworkingImpl;
import net.azureaaron.hmapi.network.packet.c2s.PartyInfoC2SPacket;
import net.azureaaron.hmapi.network.packet.c2s.PlayerInfoC2SPacket;
import net.azureaaron.hmapi.network.packet.c2s.RegisterC2SPacket;
import net.azureaaron.hmapi.network.packet.s2c.HypixelS2CPacket;
import net.azureaaron.hmapi.network.packet.v1.s2c.LocationUpdateS2CPacket;
import net.azureaaron.hmapi.utils.PacketSendResult;
import net.azureaaron.hmapi.utils.Utils;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_8710;

public class HypixelNetworking {
    private static final Object2ObjectMap<class_8710.class_9154<HypixelS2CPacket>, IntList> VALID_EVENTS = (Object2ObjectMap)class_156.method_654((Object)new Object2ObjectOpenHashMap(), map -> map.put(LocationUpdateS2CPacket.ID, (Object)((IntList)class_156.method_654((Object)new IntArrayList(), list -> list.add(1)))));
    static final Object2IntMap<class_8710.class_9154<HypixelS2CPacket>> REGISTERED_EVENTS = new Object2IntOpenHashMap();

    private HypixelNetworking() {
    }

    public static PacketSendResult sendPartyInfoC2SPacket(int version) {
        Utils.requireIsOnHypixel();
        return HypixelNetworkingImpl.sendPacket(new PartyInfoC2SPacket(Utils.requireInRange(version, 2, 2)), false);
    }

    public static PacketSendResult sendPlayerInfoC2SPacket(int version) {
        Utils.requireIsOnHypixel();
        return HypixelNetworkingImpl.sendPacket(new PlayerInfoC2SPacket(Utils.requireInRange(version, 1, 1)), false);
    }

    public static void registerToEvents(Object2IntMap<class_8710.class_9154<HypixelS2CPacket>> requestedEvents) {
        Object2IntOpenHashMap newEventRegistrations = new Object2IntOpenHashMap();
        for (Object2IntMap.Entry entry : requestedEvents.object2IntEntrySet()) {
            class_8710.class_9154 id = (class_8710.class_9154)entry.getKey();
            int version = entry.getIntValue();
            if (!VALID_EVENTS.containsKey((Object)id) || !((IntList)VALID_EVENTS.get((Object)id)).contains(version)) {
                throw new UnsupportedOperationException(id.toString() + " is either not a valid event or is an unsupported version of an event!");
            }
            if (REGISTERED_EVENTS.containsKey((Object)id) && version <= REGISTERED_EVENTS.getInt((Object)id)) continue;
            newEventRegistrations.put((Object)id, version);
        }
        if (!newEventRegistrations.isEmpty()) {
            REGISTERED_EVENTS.putAll((Map)newEventRegistrations);
            if (Utils.isOnHypixel()) {
                Object2IntMap packetsToRegisterFor = (Object2IntMap)REGISTERED_EVENTS.object2IntEntrySet().stream().collect(Collectors.toMap(e -> ((class_8710.class_9154)e.getKey()).comp_2242(), Object2IntMap.Entry::getIntValue, (a, b) -> a > b ? a : b, Object2IntOpenHashMap::new));
                HypixelNetworkingImpl.sendPacket(new RegisterC2SPacket(1, (Object2IntMap<class_2960>)packetsToRegisterFor), true);
            }
        }
    }
}

