/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.repo;

import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import io.github.moulberry.repo.NEURepository;
import io.github.moulberry.repo.NEURepositoryException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class NEURepoFile {
    private NEURepository repository;
    private Path fsPath;

    public String getPath() {
        return this.repository.baseFolder.relativize(this.fsPath).toString();
    }

    public <T> T json(TypeToken<T> type) throws NEURepositoryException {
        try {
            return (T)this.repository.gson.fromJson((Reader)Files.newBufferedReader(this.fsPath, StandardCharsets.UTF_8), type.getType());
        }
        catch (IOException | SecurityException e) {
            throw new NEURepositoryException(this.getPath(), "Could not read file", e);
        }
        catch (JsonSyntaxException e) {
            throw new NEURepositoryException(this.getPath(), "Invalid Json Syntax", e);
        }
    }

    public <T> T json(Class<T> $class) throws NEURepositoryException {
        try {
            return (T)this.repository.gson.fromJson((Reader)Files.newBufferedReader(this.fsPath, StandardCharsets.UTF_8), $class);
        }
        catch (IOException | SecurityException e) {
            throw new NEURepositoryException(this.getPath(), "Could not read file", e);
        }
        catch (JsonSyntaxException e) {
            throw new NEURepositoryException(this.getPath(), "Invalid Json Syntax", e);
        }
    }

    public InputStream stream() throws NEURepositoryException {
        try {
            return Files.newInputStream(this.fsPath, new OpenOption[0]);
        }
        catch (IOException | SecurityException e) {
            throw new NEURepositoryException(this.getPath(), "Could not read file", e);
        }
    }

    public boolean isFile() {
        return Files.isRegularFile(this.fsPath, new LinkOption[0]);
    }

    NEURepoFile(NEURepository repository, Path fsPath) {
        this.repository = repository;
        this.fsPath = fsPath;
    }

    public NEURepository getRepository() {
        return this.repository;
    }

    public Path getFsPath() {
        return this.fsPath;
    }
}

