/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.legacyitemdfu.fixers;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import net.azureaaron.legacyitemdfu.TypeReferences;
import net.azureaaron.legacyitemdfu.schemas.IdentifierNormalizingSchema;

public class PostFlatteningItemIdsFix
extends DataFix {
    private static final Object2ObjectMap<String, String> NEW_IDS = (Object2ObjectMap)DataFixUtils.make((Object)new Object2ObjectOpenHashMap(), map -> {
        map.put((Object)"minecraft:melon_block", (Object)"minecraft:melon");
        map.put((Object)"minecraft:melon", (Object)"minecraft:melon_slice");
        map.put((Object)"minecraft:speckled_melon", (Object)"minecraft:glistering_melon_slice");
        map.put((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab");
        map.put((Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs");
        map.put((Object)"minecraft:cactus_green", (Object)"minecraft:green_dye");
        map.put((Object)"minecraft:rose_red", (Object)"minecraft:red_dye");
        map.put((Object)"minecraft:dandelion_yellow", (Object)"minecraft:yellow_dye");
        map.put((Object)"minecraft:clownfish", (Object)"minecraft:tropical_fish");
        map.put((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab");
        map.put((Object)"minecraft:sign", (Object)"minecraft:oak_sign");
        map.put((Object)"minecraft:grass", (Object)"minecraft:short_grass");
        map.put((Object)"minecraft:scute", (Object)"minecraft:turtle_scute");
    });

    public PostFlatteningItemIdsFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(TypeReferences.LEGACY_ITEM_STACK);
        OpticFinder itemIdFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)TypeReferences.ITEM_NAME.typeName(), IdentifierNormalizingSchema.getIdentifierType()));
        return this.fixTypeEverywhereTyped("PostFlatteningItemIdsFix", type, itemStackTyped -> {
            Optional itemId = itemStackTyped.getOptional(itemIdFinder);
            if (itemId.isPresent() && NEW_IDS.containsKey(((Pair)itemId.get()).getSecond())) {
                String newId = (String)NEW_IDS.get(((Pair)itemId.get()).getSecond());
                itemStackTyped = itemStackTyped.set(itemIdFinder, (Object)Pair.of((Object)TypeReferences.ITEM_NAME.typeName(), (Object)newId));
            }
            return itemStackTyped;
        });
    }
}

