/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.legacyitemdfu.utils;

public class IdentifierUtils {
    public static String tryParse(String id) {
        return IdentifierUtils.trySplitOn(id, ':');
    }

    private static String trySplitOn(String id, char delimiter) {
        int i = id.indexOf(delimiter);
        if (i >= 0) {
            String string = id.substring(i + 1);
            if (!IdentifierUtils.isPathValid(string)) {
                return null;
            }
            if (i != 0) {
                String string2 = id.substring(0, i);
                return IdentifierUtils.isNamespaceValid(string2) ? string2 + ":" + string : null;
            }
            return "minecraft:" + string;
        }
        return IdentifierUtils.isPathValid(id) ? "minecraft:" + id : null;
    }

    private static boolean isNamespaceValid(String namespace) {
        for (int i = 0; i < namespace.length(); ++i) {
            if (IdentifierUtils.isNamespaceCharacterValid(namespace.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPathValid(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (IdentifierUtils.isPathCharacterValid(path.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isNamespaceCharacterValid(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '.';
    }

    private static boolean isPathCharacterValid(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '/' || character == '.';
    }
}

