/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.legacyitemdfu.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class JsonHelper {
    public static String toSortedString(JsonElement json) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            JsonHelper.writeSorted(jsonWriter, json, Comparator.naturalOrder());
        }
        catch (IOException var4) {
            throw new AssertionError((Object)var4);
        }
        return stringWriter.toString();
    }

    private static void writeSorted(JsonWriter writer, @Nullable JsonElement json, @Nullable Comparator<String> comparator) throws IOException {
        if (json == null || json.isJsonNull()) {
            writer.nullValue();
        } else if (json.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive();
            if (jsonPrimitive.isNumber()) {
                writer.value(jsonPrimitive.getAsNumber());
            } else if (jsonPrimitive.isBoolean()) {
                writer.value(jsonPrimitive.getAsBoolean());
            } else {
                writer.value(jsonPrimitive.getAsString());
            }
        } else if (json.isJsonArray()) {
            writer.beginArray();
            for (JsonElement jsonElement : json.getAsJsonArray()) {
                JsonHelper.writeSorted(writer, jsonElement, comparator);
            }
            writer.endArray();
        } else {
            if (!json.isJsonObject()) {
                throw new IllegalArgumentException("Couldn't write " + String.valueOf(json.getClass()));
            }
            writer.beginObject();
            for (Map.Entry<String, JsonElement> entry : JsonHelper.sort(json.getAsJsonObject().entrySet(), comparator)) {
                writer.name(entry.getKey());
                JsonHelper.writeSorted(writer, entry.getValue(), comparator);
            }
            writer.endObject();
        }
    }

    private static Collection<Map.Entry<String, JsonElement>> sort(Collection<Map.Entry<String, JsonElement>> entries, @Nullable Comparator<String> comparator) {
        if (comparator == null) {
            return entries;
        }
        ArrayList<Map.Entry<String, JsonElement>> list = new ArrayList<Map.Entry<String, JsonElement>>(entries);
        list.sort(Map.Entry.comparingByKey(comparator));
        return list;
    }
}

