/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.repo;

import io.github.moulberry.repo.IReloadable;
import io.github.moulberry.repo.NEURepoFile;
import io.github.moulberry.repo.NEURepository;
import io.github.moulberry.repo.NEURepositoryException;
import io.github.moulberry.repo.data.NEUItem;
import io.github.moulberry.repo.util.NEUId;
import io.github.moulberry.repo.util.StreamIt;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NEUItems
implements IReloadable {
    Map<@NEUId String, NEUItem> items;

    @Override
    public void reload(NEURepository repository) throws NEURepositoryException {
        HashMap<String, NEUItem> items = new HashMap<String, NEUItem>();
        try (Stream<NEURepoFile> itemSources = repository.tree("items").filter(NEURepoFile::isFile).filter(it -> it.getFsPath().getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".json"));){
            for (NEURepoFile rf : new StreamIt<NEURepoFile>(itemSources)) {
                NEUItem item = rf.json(NEUItem.class);
                items.put(item.getSkyblockItemId(), item);
            }
        }
        this.items = items;
    }

    public @Nullable NEUItem getItemBySkyblockId(@NEUId String itemId) {
        if (this.items == null) {
            return null;
        }
        return this.items.get(itemId.toUpperCase(Locale.ROOT));
    }

    public Map<@NEUId String, NEUItem> getItems() {
        return this.items;
    }
}

