/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.networth;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;

public record Calculation(Type type, String id, double price, int count) {
    private static final Codec<Calculation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.comapFlatMap(name -> {
        try {
            return DataResult.success((Object)((Object)Type.valueOf(name)));
        }
        catch (IllegalArgumentException ignored) {
            return DataResult.error(() -> "Unknown calculation type: " + name);
        }
    }, Enum::name).fieldOf("type").forGetter(Calculation::type), (App)Codec.STRING.fieldOf("id").forGetter(Calculation::id), (App)Codec.DOUBLE.fieldOf("price").forGetter(Calculation::price), (App)Codec.INT.fieldOf("count").forGetter(Calculation::count)).apply((Applicative)instance, Calculation::new));
    public static final Codec<List<Calculation>> LIST_CODEC = CODEC.listOf();

    static Calculation of(Type type, String id, double price) {
        return new Calculation(type, id, price, 1);
    }

    static Calculation of(Type type, String id, double price, int count) {
        return new Calculation(type, id, price, count);
    }

    Calculation add(double addedPrice) {
        return new Calculation(this.type, this.id, this.price + addedPrice, this.count);
    }

    public static enum Type {
        STAR,
        PRESTIGE,
        GOD_ROLL,
        SHEN_AUCTION,
        WINNING_BID,
        ENCHANTMENT,
        SKIN,
        SILEX,
        GOLDEN_BOUNTY,
        ATTRIBUTE,
        POCKET_SACK_IN_A_SACK,
        WOOD_SINGULARITY,
        JALAPENO_BOOK,
        TRANSMISSION_TUNER,
        MANA_DISINTEGRATOR,
        THUNDER_IN_A_BOTTLE,
        RUNE,
        FUMING_POTATO_BOOK,
        HOT_POTATO_BOOK,
        DYE,
        ART_OF_WAR,
        ART_OF_PEACE,
        FARMING_FOR_DUMMIES,
        TALISMAN_ENRICHMENT,
        RECOMBOBULATOR,
        GEMSTONE_SLOT,
        GEMSTONE,
        POWER_SCROLL,
        REFORGE,
        MASTER_STAR,
        WITHER_BLADE_SCROLL,
        DRILL_PART,
        POLARVOID_BOOK,
        DIVAN_POWDER_COATING,
        ETHERWARP_CONDUIT,
        NEW_YEAR_CAKES,
        PET_ITEM,
        SACK_ITEM,
        ESSENCE;

    }
}

