/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.networth;

import java.util.List;
import java.util.function.ToDoubleFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.azureaaron.networth.Calculation;
import net.azureaaron.networth.NetworthResult;
import net.azureaaron.networth.utils.ItemConstants;

public class MiscCalculators {
    private static final Pattern API_RUNE_PATTERN = Pattern.compile("RUNE_(?<rune>[A-Z_]+)_(?<level>\\d)");

    private MiscCalculators() {
    }

    public static NetworthResult calculateSackItem(String id, int count, ToDoubleFunction<String> prices) {
        Matcher matcher = API_RUNE_PATTERN.matcher((CharSequence)id);
        if (matcher.matches() && !ItemConstants.VALID_RUNES.contains(id = matcher.group("rune") + "_RUNE_" + Integer.parseInt(matcher.group("level")))) {
            return NetworthResult.EMPTY;
        }
        Calculation calculation = Calculation.of(Calculation.Type.SACK_ITEM, (String)id, prices.applyAsDouble((String)id) * (double)count, count);
        return NetworthResult.of(calculation.price(), calculation.price(), List.of(calculation));
    }

    public static NetworthResult calculateEssence(String essenceType, int count, ToDoubleFunction<String> prices) {
        Calculation calculation = Calculation.of(Calculation.Type.ESSENCE, essenceType, prices.applyAsDouble("ESSENCE_" + essenceType) * (double)count, count);
        return NetworthResult.of(calculation.price(), calculation.price(), List.of(calculation));
    }
}

