/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.repo;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.github.moulberry.repo.IReloadable;
import io.github.moulberry.repo.NEURepoFile;
import io.github.moulberry.repo.NEURepository;
import io.github.moulberry.repo.NEURepositoryException;
import io.github.moulberry.repo.constants.Bonuses;
import io.github.moulberry.repo.constants.Enchants;
import io.github.moulberry.repo.constants.EssenceCosts;
import io.github.moulberry.repo.constants.FairySouls;
import io.github.moulberry.repo.constants.Islands;
import io.github.moulberry.repo.constants.Leveling;
import io.github.moulberry.repo.constants.Misc;
import io.github.moulberry.repo.constants.Parents;
import io.github.moulberry.repo.constants.PetLevelingData;
import io.github.moulberry.repo.constants.PetNumbers;
import io.github.moulberry.repo.data.Rarity;
import io.github.moulberry.repo.util.PetId;
import java.util.List;
import java.util.Map;

public class NEUConstants
implements IReloadable {
    Bonuses bonuses;
    Parents parents;
    Enchants enchants;
    EssenceCosts essenceCost;
    FairySouls fairySouls;
    Misc misc;
    Leveling leveling;
    PetLevelingData petLevelingData;
    Map<@PetId String, Map<Rarity, PetNumbers>> petNumbers;
    Islands islands;

    @Override
    public void reload(NEURepository repository) throws NEURepositoryException {
        this.bonuses = repository.requireFile("constants/bonuses.json").json(Bonuses.class);
        this.parents = new Parents(repository.requireFile("constants/parents.json").json(new TypeToken<Map<String, List<String>>>(){}));
        this.enchants = repository.requireFile("constants/enchants.json").json(Enchants.class);
        this.essenceCost = new EssenceCosts(repository.requireFile("constants/essencecosts.json").json(JsonObject.class));
        this.fairySouls = new FairySouls(repository.gson, repository.requireFile("constants/fairy_souls.json").json(new TypeToken<Map<String, JsonElement>>(){}));
        this.misc = repository.requireFile("constants/misc.json").json(Misc.class);
        this.leveling = repository.requireFile("constants/leveling.json").json(Leveling.class);
        this.petLevelingData = repository.requireFile("constants/pets.json").json(PetLevelingData.class);
        this.petNumbers = repository.requireFile("constants/petnums.json").json(new TypeToken<Map<String, Map<Rarity, PetNumbers>>>(){});
        NEURepoFile islandsFile = repository.file("constants/islands.json");
        this.islands = islandsFile != null ? islandsFile.json(Islands.class) : new Islands();
    }

    public Bonuses getBonuses() {
        return this.bonuses;
    }

    public Parents getParents() {
        return this.parents;
    }

    public Enchants getEnchants() {
        return this.enchants;
    }

    public EssenceCosts getEssenceCost() {
        return this.essenceCost;
    }

    public FairySouls getFairySouls() {
        return this.fairySouls;
    }

    public Misc getMisc() {
        return this.misc;
    }

    public Leveling getLeveling() {
        return this.leveling;
    }

    public PetLevelingData getPetLevelingData() {
        return this.petLevelingData;
    }

    public Map<@PetId String, Map<Rarity, PetNumbers>> getPetNumbers() {
        return this.petNumbers;
    }

    public Islands getIslands() {
        return this.islands;
    }
}

