/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.admiral.impl;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.impl.AdmiralImpl;
import de.maxhenkel.admiral.impl.AdmiralMethod;
import de.maxhenkel.admiral.impl.permissions.Permission;
import de.maxhenkel.admiral.impl.permissions.PermissionAnnotationUtil;
import de.maxhenkel.admiral.permissions.PermissionManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AdmiralClass<S, C> {
    private boolean registered;
    private AdmiralImpl<S, C> admiral;
    private final Class<?> clazz;
    private Object instance;
    private List<Command> commands;
    private List<Permission<S>> requiredPermissions;
    private Map<String, List<List<Permission<S>>>> permissions;

    public AdmiralClass(AdmiralImpl<S, C> admiral, Class<?> clazz) {
        this.admiral = admiral;
        this.clazz = clazz;
        this.permissions = new LinkedHashMap<String, List<List<Permission<S>>>>();
    }

    public void register() {
        if (this.registered) {
            throw new IllegalStateException("Already registered");
        }
        try {
            Constructor<?> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.instance = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Class %s does not have a no-arguments constructor", this.clazz.getSimpleName()), e);
        }
        this.commands = Arrays.asList((Command[])this.clazz.getDeclaredAnnotationsByType(Command.class));
        this.requiredPermissions = PermissionAnnotationUtil.getPermissions(this.clazz);
        Method[] declaredMethods = this.clazz.getDeclaredMethods();
        int registeredMethods = 0;
        for (Method method : declaredMethods) {
            method.setAccessible(true);
            if (((Command[])method.getDeclaredAnnotationsByType(Command.class)).length == 0) continue;
            ++registeredMethods;
            AdmiralMethod admiralMethod = new AdmiralMethod(this, method);
            List nodes = admiralMethod.register();
            List<List<String>> classPaths = this.getPaths();
            if (classPaths.isEmpty()) {
                classPaths.add(new ArrayList());
            }
            for (List<String> path : classPaths) {
                if (path.isEmpty()) {
                    for (AdmiralMethod.WrappedArgumentBuilder node : nodes) {
                        if (!(node.builder instanceof LiteralArgumentBuilder)) continue;
                        this.admiral.getDispatcher().register((LiteralArgumentBuilder)node.builder);
                    }
                    continue;
                }
                LiteralArgumentBuilder last = null;
                for (int i = path.size() - 1; i >= 0; --i) {
                    LiteralArgumentBuilder literal = LiteralArgumentBuilder.literal((String)path.get(i));
                    if (last != null) {
                        literal.then(last);
                    } else {
                        for (AdmiralMethod.WrappedArgumentBuilder node : nodes) {
                            if (node.builder == null) {
                                admiralMethod.execute(literal);
                                continue;
                            }
                            if (node.needsExecution) {
                                admiralMethod.execute(literal);
                            }
                            literal.then(node.builder);
                        }
                    }
                    last = literal;
                }
                this.admiral.getDispatcher().register(last);
            }
        }
        if (this.commands.isEmpty() && registeredMethods == 0) {
            throw new IllegalStateException(String.format("Class %s does not contain any commands", this.clazz.getSimpleName()));
        }
        this.registered = true;
    }

    public AdmiralImpl<S, C> getAdmiral() {
        return this.admiral;
    }

    public Map<String, List<List<Permission<S>>>> getPermissions() {
        return this.permissions;
    }

    public boolean checkClassPermissions(S source, @Nullable PermissionManager<S> permissionManager) {
        return this.requiredPermissions.stream().allMatch(permission -> permission.hasPermission(source, permissionManager));
    }

    @Nullable
    public Object getInstance() {
        return this.instance;
    }

    public List<List<String>> getPaths() {
        return this.commands.stream().map(command -> Arrays.asList(command.value())).collect(Collectors.toList());
    }
}

