/*
 * Decompiled with CFR 0.152.
 */
package dev.cbyrne.betterinject.utils;

import org.objectweb.asm.Type;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class CallbackInfoUtils {
    public static final String DESCRIPTOR = String.format("L%s;", CallbackInfo.class.getName().replace(".", "/"));
    public static final String RETURNABLE_DESCRIPTOR = String.format("L%s;", CallbackInfoReturnable.class.getName().replace(".", "/"));
    public static final String CTOR = "(Ljava/lang/String;Z)V";

    public static String constructorDescriptor(Type returnType) {
        if (returnType.equals((Object)Type.VOID_TYPE)) {
            return CTOR;
        }
        if (returnType.getSort() == 10 || returnType.getSort() == 9) {
            return String.format("(%sZ%s)V", "Ljava/lang/String;", "Ljava/lang/Object;");
        }
        return String.format("(%sZ%s)V", "Ljava/lang/String;", returnType.getDescriptor());
    }

    public static boolean typeIsCallbackInfo(Type type) {
        String desc = type.getDescriptor();
        return desc.equals(DESCRIPTOR) || desc.equals(RETURNABLE_DESCRIPTOR);
    }

    public static String returnFunctionName(Type returnType) {
        if (returnType.getSort() == 10 || returnType.getSort() == 9) {
            return "getReturnValue";
        }
        return String.format("getReturnValue%s", returnType.getDescriptor());
    }

    public static String returnFunctionDescriptor(Type returnType) {
        if (returnType.getSort() == 10 || returnType.getSort() == 9) {
            return String.format("()%s", "Ljava/lang/Object;");
        }
        return String.format("()%s", returnType.getDescriptor());
    }
}

