/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.admiral.impl;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.admiral.Admiral;
import de.maxhenkel.admiral.impl.AdmiralClass;
import de.maxhenkel.admiral.impl.ArgumentTypeRegistryImpl;
import de.maxhenkel.admiral.permissions.PermissionManager;
import javax.annotation.Nullable;

public class AdmiralImpl<S, C>
extends Admiral<S, C> {
    private ArgumentTypeRegistryImpl argumentRegistry;
    private CommandDispatcher<S> dispatcher;
    @Nullable
    private C commandBuildContext;
    @Nullable
    private PermissionManager<S> permissionManager;

    protected AdmiralImpl() {
    }

    public static <S, C> Builder<S, C> builder(CommandDispatcher<S> dispatcher, @Nullable C commandBuildContext) {
        return new Builder<S, C>(dispatcher, commandBuildContext);
    }

    public ArgumentTypeRegistryImpl getArgumentRegistry() {
        return this.argumentRegistry;
    }

    public CommandDispatcher<S> getDispatcher() {
        return this.dispatcher;
    }

    @Nullable
    public C getCommandBuildContext() {
        return this.commandBuildContext;
    }

    @Nullable
    public PermissionManager<S> getPermissionManager() {
        return this.permissionManager;
    }

    public static class Builder<S, C>
    extends Admiral.Builder<S, C> {
        protected Builder(CommandDispatcher<S> dispatcher, @Nullable C commandBuildContext) {
            super(dispatcher, commandBuildContext);
        }

        @Override
        public AdmiralImpl<S, C> build() {
            AdmiralImpl admiral = new AdmiralImpl();
            admiral.argumentRegistry = this.argumentRegistry;
            admiral.dispatcher = this.dispatcher;
            admiral.commandBuildContext = this.commandBuildContext;
            admiral.permissionManager = this.permissionManager;
            for (Class c : this.classes) {
                AdmiralClass admiralClass = new AdmiralClass(admiral, c);
                admiralClass.register();
            }
            return admiral;
        }
    }
}

