/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.listener;

import me.mraxetv.beastlib.lib.nbtapi.NBTItem;
import me.mraxetv.beastlib.lib.nbtapi.utils.MinecraftVersion;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CancelCraftingListener
implements Listener {
    BeastWithdrawPlugin pl;
    private boolean crafting;
    private boolean hasShopKeeper;

    public CancelCraftingListener(BeastWithdrawPlugin pl) {
        this.pl = pl;
        pl.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)pl);
        this.crafting = pl.getConfig().getBoolean("Settings.CancelCrafting");
        this.hasShopKeeper = pl.getServer().getPluginManager().isPluginEnabled("Shopkeepers");
    }

    @EventHandler
    public void nocraft(InventoryClickEvent e) {
        if (!this.crafting) {
            return;
        }
        if (e.getWhoClicked().getOpenInventory().getTopInventory().getType() != InventoryType.WORKBENCH) {
            return;
        }
        ItemStack itemStack = e.getCurrentItem();
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (!itemStack.hasItemMeta()) {
            return;
        }
        NBTItem nbtItem = new NBTItem(itemStack);
        if (!nbtItem.hasKey("bCraft").booleanValue()) {
            return;
        }
        e.setCancelled(true);
        String s = this.pl.getMessages().getString("Withdraws.CancelCrafting");
        this.pl.getUtils().sendMessage((CommandSender)e.getView().getPlayer(), s);
    }

    @EventHandler
    public void noGrindStone(InventoryClickEvent e) {
        if (!MinecraftVersion.isAtLeastVersion((MinecraftVersion)MinecraftVersion.MC1_14_R1)) {
            return;
        }
        if (e.getWhoClicked().getOpenInventory().getTopInventory().getType() != InventoryType.GRINDSTONE) {
            return;
        }
        ItemStack itemStack = e.getCurrentItem();
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (!itemStack.hasItemMeta()) {
            return;
        }
        NBTItem nbtItem = new NBTItem(itemStack);
        if (!nbtItem.hasKey("bCraft").booleanValue()) {
            return;
        }
        e.setCancelled(true);
        String s = this.pl.getMessages().getString("Withdraws.CancelGrindStone");
        this.pl.getUtils().sendMessage((CommandSender)e.getView().getPlayer(), s);
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (!this.pl.getConfig().getBoolean("Settings.VillagerTrade.Allow") && e.getInventory().getType() == InventoryType.MERCHANT) {
            Player p = (Player)e.getWhoClicked();
            if (e.getCurrentItem() == null) {
                return;
            }
            if (e.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            ItemStack item = e.getCurrentItem();
            if (!item.hasItemMeta()) {
                return;
            }
            NBTItem tag = new NBTItem(item);
            if (tag.hasKey("bCraft").booleanValue()) {
                if (e.getWhoClicked().getOpenInventory().getTopInventory().getHolder() == null && this.pl.getConfig().getBoolean("Settings.VillagerTrade.AllowShopKeeperPlugin")) {
                    return;
                }
                String s = this.pl.getMessages().getString("Withdraws.CancelVillagerTrade");
                this.pl.getUtils().sendMessage((CommandSender)p, s);
                e.setCancelled(true);
            }
        }
    }
}

