/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.quests.workers.pipeline.steps;

import com.google.common.collect.Sets;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.BattlePassApi;
import io.github.battlepass.api.events.user.UserQuestProgressionEvent;
import io.github.battlepass.controller.QuestController;
import io.github.battlepass.entity.BoosterEntity;
import io.github.battlepass.entity.UserEntity;
import io.github.battlepass.enums.Category;
import io.github.battlepass.logger.DebugLogger;
import io.github.battlepass.logger.containers.LogContainer;
import io.github.battlepass.objects.quests.EventCategory;
import io.github.battlepass.objects.quests.Quest;
import io.github.battlepass.quests.workers.pipeline.processors.AntiAbuseProcessor;
import io.github.battlepass.quests.workers.pipeline.steps.QuestCompletionStep;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.security.Key;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import me.hyfe.simplespigot.config.Config;
import net.advancedplugins.bp.impl.actions.ActionExecution;
import net.advancedplugins.bp.impl.actions.containers.ActionContainer;
import net.advancedplugins.bp.impl.actions.objects.variable.ExecutableActionResult;
import net.advancedplugins.bp.impl.actions.objects.variable.Variable;
import net.advancedplugins.bp.impl.utils.FoliaScheduler;
import net.advancedplugins.bp.impl.utils.Locks;
import net.advancedplugins.bp.impl.utils.k;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class QuestValidationStep {
    private final AntiAbuseProcessor I;
    private final QuestCompletionStep o;
    private final BattlePlugin O;
    private final BattlePassApi T;
    private final DebugLogger Z;
    private final QuestController a;
    private final Set<String> r;
    private final Set<String> t;
    private final boolean M;
    private final boolean j;
    private final boolean U;
    private final boolean D;
    private final boolean c;
    private final ReentrantLock V;
    private static int H;
    private static final long b;
    private static final String[] d;

    public QuestValidationStep(BattlePlugin battlePlugin) {
        long l = b ^ 0x2A30450453A1L;
        this.V = Locks.newReentrantLock();
        String[] stringArray = d;
        Config config = battlePlugin.getConfig(stringArray[10]);
        this.I = new AntiAbuseProcessor(battlePlugin);
        this.o = new QuestCompletionStep(battlePlugin);
        int n = QuestValidationStep.y();
        this.O = battlePlugin;
        this.T = battlePlugin.getLocalApi();
        this.a = battlePlugin.getQuestController();
        this.r = Sets.newHashSet(config.stringList(stringArray[2]));
        this.t = Sets.newHashSet(config.stringList(stringArray[3]));
        this.M = config.bool(stringArray[5]);
        this.j = config.bool(stringArray[4]);
        this.U = config.bool(stringArray[14]);
        this.D = config.bool(stringArray[1]);
        this.c = config.bool(stringArray[8]);
        this.Z = battlePlugin.getDebugLogger();
        if (ActionContainer.O() != null) {
            QuestValidationStep.V(++n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCompletion(ActionExecution actionExecution, Collection<Quest> collection) {
        long l = b ^ 0x6857CD70DFAL;
        Player player = actionExecution.getPlayer();
        int n = QuestValidationStep.n();
        String string = player.getWorld().getName();
        if (this.areServerQuestsBlocked()) {
            String[] stringArray = d;
            this.Z.log(LogContainer.of(stringArray[0]));
            return;
        }
        if (this.isWorldServerBlocked(string)) {
            return;
        }
        this.I.applyMeasures(actionExecution, collection);
        for (Quest quest : collection) {
            EventCategory eventCategory;
            BigDecimal bigDecimal;
            if (quest.getCurrentStep(bigDecimal = this.a.getQuestProgress((UserEntity)actionExecution.getUser(), quest)) == null || !actionExecution.getQuestType().equalsIgnoreCase(quest.getCurrentStep(bigDecimal).getType()) && n != 0) continue;
            if (this.isQuestSeasonEndBlocked(quest)) {
                String[] stringArray = d;
                this.Z.log(LogContainer.of(stringArray[12]));
                if (n != 0) continue;
            }
            if (quest.getCategoryId().contains(d[11]) && ((eventCategory = this.O.getQuestCache().getEventCategories().get(quest.getCategoryId())) == null || !eventCategory.canAccess(player))) continue;
            this.V.lock();
            try {
                this.proceed(actionExecution, quest);
            }
            finally {
                this.V.unlock();
            }
            if (n != 0) continue;
        }
    }

    public boolean proceed(ActionExecution actionExecution, Quest quest) {
        long l = b ^ 0x62AA683506F2L;
        BigDecimal bigDecimal = this.a.getQuestProgress((UserEntity)actionExecution.getUser(), quest);
        Quest.Step step = quest.getCurrentStep(bigDecimal);
        if (!this.isQuestValid(actionExecution, quest, step)) {
            return false;
        }
        if (this.isRegionQuestBlocked(actionExecution, step)) {
            return false;
        }
        Variable variable = quest.getCurrentStep(bigDecimal).getVariable();
        ExecutableActionResult executableActionResult = actionExecution.getQuestResult();
        double d2 = executableActionResult.isEligible(actionExecution.getPlayer(), variable);
        if (d2 > 0.0) {
            BigDecimal bigDecimal2 = actionExecution.getDecimalProgress().multiply(BigDecimal.valueOf(quest.getCurrentStep(bigDecimal).getSpecialProgress().getOrDefault(executableActionResult.getEffectiveRoot(), 1.0))).multiply(BigDecimal.valueOf(d2)).multiply(BigDecimal.valueOf(this.O.getBoostersController().calculateFinalBooster(actionExecution.getPlayer().getUniqueId(), BoosterEntity.BoosterType.PROGRESS, quest) / 100.0 + 1.0));
            UserQuestProgressionEvent userQuestProgressionEvent = new UserQuestProgressionEvent(actionExecution, quest, bigDecimal2, actionExecution.canBeAsync() && !FoliaScheduler.isFolia());
            Bukkit.getPluginManager().callEvent((Event)userQuestProgressionEvent);
            if (!userQuestProgressionEvent.isCancelled()) {
                this.o.process(actionExecution, quest, bigDecimal, userQuestProgressionEvent.getAddedProgress());
            }
            return true;
        }
        return false;
    }

    public boolean isQuestPrimarilyValid(UserEntity userEntity, Quest quest, Quest.Step step, BigDecimal bigDecimal, boolean bl) {
        boolean bl2;
        long l = b ^ 0x54AE8EE5FC61L;
        if (this.areServerQuestsBlocked() || this.isQuestSeasonEndBlocked(quest) || this.a.isQuestDone(userEntity, quest) || bl && this.isProgressIdentical(quest, userEntity, bigDecimal) || this.isPassTypeQuestBlocked(step, userEntity)) {
            return false;
        }
        int n = Category.stripWeek(quest.getCategoryId());
        boolean bl3 = bl2 = n == 0;
        if (!bl2 && !userEntity.bypassesLockedWeeks() && ((long)n > this.T.getCurrentWeek() || this.M && (long)n < this.T.getCurrentWeek())) {
            return false;
        }
        return !this.j || bl2 || userEntity.bypassesLockedWeeks() || !this.isPreviousWeekBlocked(userEntity, n);
    }

    public boolean isQuestValid(ActionExecution actionExecution, Quest quest, Quest.Step step) {
        long l = b ^ 0x51B57432946AL;
        if (!this.isQuestPrimarilyValid((UserEntity)actionExecution.getUser(), quest, step, actionExecution.getDecimalProgress(), actionExecution.shouldOverrideUpdate())) {
            return false;
        }
        Player player = actionExecution.getPlayer();
        String string = player.getWorld().getName();
        return !this.isWorldQuestBlocked(step, string);
    }

    private boolean areServerQuestsBlocked() {
        long l = b ^ 0x2279DFFB079DL;
        return this.T.hasSeasonEnded() && this.U && this.D;
    }

    private boolean isWorldServerBlocked(String string) {
        long l = b ^ 0x478C93526B4BL;
        return !this.r.isEmpty() && !this.r.contains(string) || this.t.contains(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isQuestSeasonEndBlocked(Quest quest) {
        long l = b ^ 0x1F5C8CC1B24AL;
        if (!this.T.hasSeasonEnded()) return false;
        String[] stringArray = d;
        if (quest.getCategoryId().contains(stringArray[13])) {
            if (this.U) return true;
        }
        stringArray = d;
        if (quest.getCategoryId().contains(stringArray[7])) {
            if (this.D) return true;
        }
        if (!quest.getCategoryId().contains(d[6])) return false;
        if (!this.c) return false;
        return true;
    }

    private boolean isWorldQuestBlocked(Quest.Step step, String string) {
        long l = b ^ 0x19369E4B1D22L;
        return step.getBlacklistedWorlds().contains(string) || !step.getWhitelistedWorlds().isEmpty() && !step.getWhitelistedWorlds().contains(string);
    }

    private boolean isPassTypeQuestBlocked(Quest.Step step, UserEntity userEntity) {
        long l = b ^ 0xBC6364B601EL;
        return step.getExclusiveTo() != null && !step.getExclusiveTo().equalsIgnoreCase(userEntity.getPassId());
    }

    private boolean isProgressIdentical(Quest quest, UserEntity userEntity, BigDecimal bigDecimal) {
        long l = b ^ 0xB0757867DEBL;
        return this.a.getQuestProgress(userEntity, quest).compareTo(bigDecimal) == 0;
    }

    private boolean isPreviousWeekBlocked(UserEntity userEntity, int n) {
        boolean bl;
        block2: {
            long l = b ^ 0x1C5FAA3BE198L;
            int n2 = QuestValidationStep.n();
            for (int i = n - 1; i > 0; --i) {
                bl = this.a.isWeekDone(userEntity, i);
                if (n2 != 0) {
                    if (bl) continue;
                    return true;
                }
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private boolean isRegionQuestBlocked(ActionExecution actionExecution, Quest.Step step) {
        long l = b ^ 0x30B98D036922L;
        UserEntity userEntity = (UserEntity)actionExecution.getUser();
        int n = QuestValidationStep.y();
        if (!this.O.getServer().getPluginManager().isPluginEnabled(d[9])) {
            return false;
        }
        if (step.getWhitelistedRegions().isEmpty() && step.getBlacklistedRegions().isEmpty()) {
            return false;
        }
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regionManager = regionContainer.get(BukkitAdapter.adapt((World)userEntity.getPlayer().getWorld()));
        ApplicableRegionSet applicableRegionSet = regionContainer.createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)userEntity.getPlayer().getLocation()));
        if (regionManager == null) {
            return false;
        }
        if (!step.getWhitelistedRegions().isEmpty()) {
            for (String string : step.getWhitelistedRegions()) {
                ProtectedRegion protectedRegion = regionManager.getRegion(string);
                if (protectedRegion != null && applicableRegionSet.getRegions().contains(protectedRegion)) {
                    return false;
                }
                if (n == 0) continue;
            }
            return true;
        }
        if (!step.getBlacklistedRegions().isEmpty()) {
            for (String string : step.getBlacklistedRegions()) {
                ProtectedRegion protectedRegion = regionManager.getRegion(string);
                if (protectedRegion != null && applicableRegionSet.getRegions().contains(protectedRegion)) {
                    return true;
                }
                if (n == 0) continue;
            }
        }
        return false;
    }

    public static void V(int n) {
        H = n;
    }

    public static int n() {
        return H;
    }

    public static int y() {
        int n = QuestValidationStep.n();
        if (n == 0) {
            return 41;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block11: {
            block10: {
                QuestValidationStep.b = k.a(-2153280110706515919L, 8512201395923357391L, MethodHandles.lookup().lookupClass()).a(102676237786160L);
                var0 = QuestValidationStep.b ^ 74734257171058L;
                QuestValidationStep.V(114);
                var2_1 = Cipher.getInstance("DES/CBC/PKCS5Padding");
                v0 = SecretKeyFactory.getInstance("DES");
                v1 = new byte[8];
                v2 = v1;
                v1[0] = (byte)(var0 >>> 56);
                for (var3_2 = 1; var3_2 < 8; ++var3_2) {
                    v2 = v2;
                    v2[var3_2] = (byte)(var0 << var3_2 * 8 >>> 56);
                }
                var2_1.init(2, (Key)v0.generateSecret(new DESKeySpec(v2)), new IvParameterSpec(new byte[8]));
                var9_3 = new String[15];
                var7_4 = 0;
                var6_5 = "p\u00b6\u000e\u0086\u0005<\u001bA\u00d0\u000f\u00aa\u0089.|\u00876\u000f`\u009c&~\u00ef\u0087\u00e6_\u0014\u001b\u0094v\u00a4\u0088E\u00a3\u0084\u00c1)\u0014\u0093D\u009a\u00a4\u00a0\u00a6\u00bezD#\u00e2[\u00f2'\u00cf\u00c1\u00ffD\u00c3\n5rf\u00c9+\r\u00f2\u009b\u007f\u0014\fX\u00b2A\u00c2l\u00db\u0082a\u009f\u00b3\u00e3(V@\u00ec-\u001a\u0085\u001b\u00b8\u0002\u007f]\u00b8:\u00df\u00cb\u00e1\u007f) \u000b\u00b9_X\u00a6\u00b5\u00b2\u00c9\u00f1\u001b\u000eY\u000f(\u00cc\u00be`\u00de'\u00fa#\u00ed\u0014?\u008d\u00a1\u00b0\u0005\u00f7.g\u00f0\u0014$C\u00b0\u00fa\u00ae%i\u0001+\u00a5\u00d3>\u001e_\u00fe\u00e3\u00e5\u00b4-(\u0019\u0018\u00a9\u0093\u0096f\u00d1v\u00eeo\u0085\u00ea\u0012\u00f6J\u00f3o\u00fd\u0094\u0080\u007fy\u00bdET\u0088\u0018\u00cb\u00d1QA\u00ff$\u00cah\u00a5\u009d\u00ef\u0007*\u00b2\u00eft\u001a\u0082\u0018\u001c\u009a\u009e\u00e9\u00a58\u00c3\u0097<\u00b5\t\u0082\u00ce#Y,\u0096d!?39\u00f7%\u00eb\b\u001c2\u00fe\u00d91\u0084>\u0080-\u00c2\u00c2?\u00ac\u00e3\u001d6\u001fj\u0094\u00af^\u00b3\u00f3\u008a~K\u0087\u0001\u00b6K\u00cc\u0010_\u001e2a0\u00c3\u0097<\u00b5\t\u0082\u00ce#Y,\u0096d!?39\u00bc\u00c9\u00cab\r*\u00a0(\u0092\u00a15n\u00abk\u00fa\u00few0\u00cd\u00bb?9.\u00eao\u00e7\u00d8\u008at\u00a0\u00b8\u001d\bT\u00b43)\t\u00ca\u001d)\be\u0011\u00e4\u00b6H0\u0092v(\u00cc\u00be`\u00de'\u00fa#\u00ed\u0014?\u008d\u00a1\u00b0\u0005\u00f7.tG\u00b8\u0000{5\u00ac)\u00ef\u0088\u00a5K\u00dds\u00b91\u00a8I\u00fd\u001f;\u0004-\u00ee\u0010\u0085\u00cb\u00d1U\u0015\"\u00ff\u00f8\u00ea\u0090\u00cb\u00e4\u00196\u00cf\u00e5\u0010\u00f3\u0013\u00b2\u00e1>\r\u0007\u00c7m\u00e3\u0087\u0003\u00bbl\u00a9\u0010\bT\u00b43)\t\u00ca\u001d)hp\u00b6\u000e\u0086\u0005<\u001bA\u00d0\u000f\u00aa\u0089.|\u00876\u000f`\u009c&~\u00ef\u0087\u00e6_\u0014\u001b\u0094v\u00a4\u0088E\u00a3\u0084\u00c1)\u0014\u0093D\u009a\u00a4\u00a0\u00a6\u00bezD#\u00e2\u0091\u009e`\u00aa(\u009b\u0098\u00d8\u0000CZ\u00d8\b2d(\u009c\u00e2\u00fe\u0018s\u00f6I\u0090\u00ce\u0000\u0005r?/p\u00be\u0087\u00b5\u0084{l\u00e5\u00ab\u00ab\u00c1\u00bc\u00a6?RDP\u00c2\u0089\u00c7C\u0094\u0014e\u001ct";
                var8_6 = "p\u00b6\u000e\u0086\u0005<\u001bA\u00d0\u000f\u00aa\u0089.|\u00876\u000f`\u009c&~\u00ef\u0087\u00e6_\u0014\u001b\u0094v\u00a4\u0088E\u00a3\u0084\u00c1)\u0014\u0093D\u009a\u00a4\u00a0\u00a6\u00bezD#\u00e2[\u00f2'\u00cf\u00c1\u00ffD\u00c3\n5rf\u00c9+\r\u00f2\u009b\u007f\u0014\fX\u00b2A\u00c2l\u00db\u0082a\u009f\u00b3\u00e3(V@\u00ec-\u001a\u0085\u001b\u00b8\u0002\u007f]\u00b8:\u00df\u00cb\u00e1\u007f) \u000b\u00b9_X\u00a6\u00b5\u00b2\u00c9\u00f1\u001b\u000eY\u000f(\u00cc\u00be`\u00de'\u00fa#\u00ed\u0014?\u008d\u00a1\u00b0\u0005\u00f7.g\u00f0\u0014$C\u00b0\u00fa\u00ae%i\u0001+\u00a5\u00d3>\u001e_\u00fe\u00e3\u00e5\u00b4-(\u0019\u0018\u00a9\u0093\u0096f\u00d1v\u00eeo\u0085\u00ea\u0012\u00f6J\u00f3o\u00fd\u0094\u0080\u007fy\u00bdET\u0088\u0018\u00cb\u00d1QA\u00ff$\u00cah\u00a5\u009d\u00ef\u0007*\u00b2\u00eft\u001a\u0082\u0018\u001c\u009a\u009e\u00e9\u00a58\u00c3\u0097<\u00b5\t\u0082\u00ce#Y,\u0096d!?39\u00f7%\u00eb\b\u001c2\u00fe\u00d91\u0084>\u0080-\u00c2\u00c2?\u00ac\u00e3\u001d6\u001fj\u0094\u00af^\u00b3\u00f3\u008a~K\u0087\u0001\u00b6K\u00cc\u0010_\u001e2a0\u00c3\u0097<\u00b5\t\u0082\u00ce#Y,\u0096d!?39\u00bc\u00c9\u00cab\r*\u00a0(\u0092\u00a15n\u00abk\u00fa\u00few0\u00cd\u00bb?9.\u00eao\u00e7\u00d8\u008at\u00a0\u00b8\u001d\bT\u00b43)\t\u00ca\u001d)\be\u0011\u00e4\u00b6H0\u0092v(\u00cc\u00be`\u00de'\u00fa#\u00ed\u0014?\u008d\u00a1\u00b0\u0005\u00f7.tG\u00b8\u0000{5\u00ac)\u00ef\u0088\u00a5K\u00dds\u00b91\u00a8I\u00fd\u001f;\u0004-\u00ee\u0010\u0085\u00cb\u00d1U\u0015\"\u00ff\u00f8\u00ea\u0090\u00cb\u00e4\u00196\u00cf\u00e5\u0010\u00f3\u0013\u00b2\u00e1>\r\u0007\u00c7m\u00e3\u0087\u0003\u00bbl\u00a9\u0010\bT\u00b43)\t\u00ca\u001d)hp\u00b6\u000e\u0086\u0005<\u001bA\u00d0\u000f\u00aa\u0089.|\u00876\u000f`\u009c&~\u00ef\u0087\u00e6_\u0014\u001b\u0094v\u00a4\u0088E\u00a3\u0084\u00c1)\u0014\u0093D\u009a\u00a4\u00a0\u00a6\u00bezD#\u00e2\u0091\u009e`\u00aa(\u009b\u0098\u00d8\u0000CZ\u00d8\b2d(\u009c\u00e2\u00fe\u0018s\u00f6I\u0090\u00ce\u0000\u0005r?/p\u00be\u0087\u00b5\u0084{l\u00e5\u00ab\u00ab\u00c1\u00bc\u00a6?RDP\u00c2\u0089\u00c7C\u0094\u0014e\u001ct".length();
                var5_7 = 112;
                var4_8 = -1;
lbl20:
                // 2 sources

                while (true) {
                    v3 = ++var4_8;
                    v4 = var6_5.substring(v3, v3 + var5_7);
                    v5 = -1;
                    break block10;
                    break;
                }
lbl25:
                // 1 sources

                while (true) {
                    var9_3[var7_4++] = QuestValidationStep.a(var10_9).intern();
                    if ((var4_8 += var5_7) < var8_6) {
                        var5_7 = var6_5.charAt(var4_8);
                        ** continue;
                    }
                    var6_5 = " \u009f,v\u009c\u0094\u00bdG(\u00cc\u00be`\u00de'\u00fa#\u00ed\u0014?\u008d\u00a1\u00b0\u0005\u00f7.\u0086\u0019yb\u00ad\u00b9\u00e8*\u0086\u009c\u00e4Z\u00a7\u00bd\u00a1Y\u000bl\u0087\u008f{\u00fe\u008f\u0002";
                    var8_6 = " \u009f,v\u009c\u0094\u00bdG(\u00cc\u00be`\u00de'\u00fa#\u00ed\u0014?\u008d\u00a1\u00b0\u0005\u00f7.\u0086\u0019yb\u00ad\u00b9\u00e8*\u0086\u009c\u00e4Z\u00a7\u00bd\u00a1Y\u000bl\u0087\u008f{\u00fe\u008f\u0002".length();
                    var5_7 = 8;
                    var4_8 = -1;
lbl34:
                    // 2 sources

                    while (true) {
                        v6 = ++var4_8;
                        v4 = var6_5.substring(v6, v6 + var5_7);
                        v5 = 0;
                        break block10;
                        break;
                    }
                    break;
                }
lbl39:
                // 1 sources

                while (true) {
                    var9_3[var7_4++] = QuestValidationStep.a(var10_9).intern();
                    if ((var4_8 += var5_7) < var8_6) {
                        var5_7 = var6_5.charAt(var4_8);
                        ** continue;
                    }
                    break block11;
                    break;
                }
            }
            var10_9 = var2_1.doFinal(v4.getBytes("ISO-8859-1"));
            switch (v5) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl51:
                // 1 sources

                ** continue;
            }
        }
        QuestValidationStep.d = var9_3;
    }

    private static String a(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            char c;
            int n3 = 0xFF & byArray[i];
            if (n3 < 192) {
                cArray[n++] = (char)n3;
                continue;
            }
            if (n3 < 224) {
                c = (char)((char)(n3 & 0x1F) << 6);
                n3 = byArray[++i];
                c = (char)(c | (char)(n3 & 0x3F));
                cArray[n++] = c;
                continue;
            }
            if (i >= n2 - 2) continue;
            c = (char)((char)(n3 & 0xF) << 12);
            n3 = byArray[++i];
            c = (char)(c | (char)(n3 & 0x3F) << 6);
            n3 = byArray[++i];
            c = (char)(c | (char)(n3 & 0x3F));
            cArray[n++] = c;
        }
        return new String(cArray, 0, n);
    }
}

